/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.function.Function;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.common.blockentities.BellowsBlockEntity;
import net.dries007.tfc.common.blocks.devices.BellowsBlock;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.Property;

public class BellowsBlockEntityRenderer
implements BlockEntityRenderer<BellowsBlockEntity> {
    private static final ResourceLocation BACK_TEXTURE = Helpers.identifier("block/devices/bellows/back");
    private static final ResourceLocation SIDE_TEXTURE = Helpers.identifier("block/devices/bellows/side");
    private static final int planeCount = 4;
    private static final float texWidth = 4.0f;
    private static final float headWidth = 0.125f;
    private static final float bellowsWidthMin = 0.125f;
    private static final float bellowsWidthMax = 0.875f;
    private static final float indentBase = 0.0125f;
    private static final float indentFactor = 1.8f;

    public static float[][] getVertices(float minX, float minY, float minZ, float maxX, float maxY, float maxZ, float changeX, float changeY) {
        return new float[][]{{minX, minY, minZ, 0.0f, 1.0f}, {minX + changeX, minY - changeY, maxZ, 1.0f, 1.0f}, {minX + changeX, maxY + changeY, maxZ, 1.0f, 0.0f}, {minX, maxY, minZ, 0.0f, 0.0f}, {maxX - changeX, minY - changeY, maxZ, 1.0f, 0.0f}, {maxX, minY, minZ, 0.0f, 0.0f}, {maxX, maxY, minZ, 0.0f, 1.0f}, {maxX - changeX, maxY + changeY, maxZ, 1.0f, 1.0f}, {minX, maxY, minZ, 0.0f, 1.0f}, {minX + changeX, maxY + changeY, maxZ, 1.0f, 1.0f}, {maxX - changeX, maxY + changeY, maxZ, 1.0f, 0.0f}, {maxX, maxY, minZ, 0.0f, 0.0f}, {minX + changeX, minY - changeY, maxZ, 1.0f, 0.0f}, {minX, minY, minZ, 0.0f, 0.0f}, {maxX, minY, minZ, 0.0f, 1.0f}, {maxX - changeX, minY - changeY, maxZ, 1.0f, 1.0f}};
    }

    public void render(BellowsBlockEntity bellows, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        int meta = ((Direction)bellows.getBlockState().getValue((Property)BellowsBlock.FACING)).get2DDataValue();
        poseStack.pushPose();
        Function atlas = Minecraft.getInstance().getTextureAtlas(RenderHelpers.BLOCKS_ATLAS);
        TextureAtlasSprite endSprite = (TextureAtlasSprite)atlas.apply(BACK_TEXTURE);
        TextureAtlasSprite sideSprite = (TextureAtlasSprite)atlas.apply(SIDE_TEXTURE);
        VertexConsumer buffer = bufferSource.getBuffer(RenderType.cutout());
        float width = 1.0f - bellows.getExtensionLength(partialTicks);
        poseStack.translate(0.5, 0.0, 0.5);
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f - 90.0f * (float)meta));
        poseStack.translate(-0.5, 0.0, -0.5);
        this.drawMiddle(buffer, poseStack, sideSprite, width, packedLight, packedOverlay);
        RenderHelpers.renderTexturedCuboid(poseStack, buffer, endSprite, packedLight, packedOverlay, 0.0f, 0.0f, width, 1.0f, 1.0f, 0.125f + width);
        poseStack.popPose();
    }

    private void drawMiddle(VertexConsumer buffer, PoseStack poseStack, TextureAtlasSprite sprite, float width, int packedLight, int packedOverlay) {
        float currentWidth;
        float widthPerSection = (width - 0.125f) / 4.0f;
        float lastWidth = currentWidth = 0.125f;
        float change = 0.0125f * (1.8f / width);
        for (int i = 0; i < 4; ++i) {
            boolean isIndented = i % 2 == 0;
            float min = isIndented ? 0.125f + change : 0.125f;
            float max = isIndented ? 0.875f - change : 0.875f;
            for (float[] v : BellowsBlockEntityRenderer.getVertices(min, max, currentWidth += widthPerSection, max, min, lastWidth, isIndented ? -change : change, isIndented ? -change : change)) {
                RenderHelpers.renderTexturedVertex(poseStack, buffer, packedLight, packedOverlay, v[0], v[1], v[2], sprite.getU((v[3] * -4.0f + 4.0f * (float)(i + 1)) * 0.0625f), sprite.getV(v[4]), 1.0f, 0.0f, 0.0f);
            }
            lastWidth = currentWidth;
        }
    }
}

