/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.common.blockentities.LoomBlockEntity;
import net.dries007.tfc.common.blocks.wood.TFCLoomBlock;
import net.dries007.tfc.common.recipes.LoomRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;

public class LoomBlockEntityRenderer
implements BlockEntityRenderer<LoomBlockEntity> {
    public void render(LoomBlockEntity loom, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        Block block = loom.getBlockState().getBlock();
        assert (block instanceof TFCLoomBlock);
        ResourceLocation texture = ((TFCLoomBlock)block).getTextureLocation();
        if (texture == null) {
            return;
        }
        poseStack.pushPose();
        poseStack.translate(0.5, 0.03125, 0.5);
        int meta = ((Direction)loom.getBlockState().getValue((Property)TFCLoomBlock.FACING)).get2DDataValue();
        poseStack.mulPose(Axis.YP.rotationDegrees((float)meta));
        poseStack.popPose();
        TextureAtlasSprite planksSprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(RenderHelpers.BLOCKS_ATLAS).apply(texture);
        float tileZ = (float)loom.getAnimPos();
        poseStack.pushPose();
        poseStack.translate(0.5, 0.0, 0.5);
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f - 90.0f * (float)meta));
        poseStack.translate(-0.5, 0.0, -0.5);
        VertexConsumer builder = buffer.getBuffer(RenderType.cutout());
        float z = loom.currentBoolean() ? tileZ : 0.0f;
        RenderHelpers.renderTexturedCuboid(poseStack, builder, planksSprite, combinedLight, combinedOverlay, 0.0625f, 0.3125f, 0.5626f - z, 0.9375f, 0.375f, 0.625f - z);
        float z1 = loom.currentBoolean() ? 0.0f : tileZ;
        RenderHelpers.renderTexturedCuboid(poseStack, builder, planksSprite, combinedLight, combinedOverlay, 0.0625f, 0.09375f, 0.5626f - z1, 0.9375f, 0.15625f, 0.625f - z1);
        poseStack.popPose();
        LoomRecipe recipe = loom.getRecipe();
        ResourceLocation lastTex = loom.getLastTexture();
        if (recipe != null || lastTex != null) {
            poseStack.pushPose();
            poseStack.translate(0.5, 0.0, 0.5);
            poseStack.mulPose(Axis.YP.rotationDegrees(180.0f - 90.0f * (float)meta));
            poseStack.translate(-0.5, 0.0, -0.5);
            if (recipe != null) {
                TextureAtlasSprite progressSprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(RenderHelpers.BLOCKS_ATLAS).apply(recipe.getInProgressTexture());
                this.drawMaterial(builder, poseStack, progressSprite, loom, recipe, tileZ * 2.0f / 3.0f, combinedOverlay, combinedLight);
                this.drawProduct(builder, poseStack, progressSprite, loom, recipe, combinedOverlay, combinedLight);
            } else {
                TextureAtlasSprite progressSprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(RenderHelpers.BLOCKS_ATLAS).apply(lastTex);
                this.drawProduct(builder, poseStack, progressSprite, 1.0f, combinedOverlay, combinedLight);
            }
            poseStack.popPose();
        }
    }

    private void drawProduct(VertexConsumer buffer, PoseStack poseStack, TextureAtlasSprite sprite, float progress, int packedOverlay, int packedLight) {
        for (float[] v : RenderHelpers.getDiagonalPlaneVertices(0.1875f, 0.9375f, 0.749f, 0.8125f, 0.9375f - 0.625f * progress, 0.749f, 0.0f, 0.0f, 1.0f, progress)) {
            RenderHelpers.renderTexturedVertex(poseStack, buffer, packedLight, packedOverlay, v[0], v[1], v[2], sprite.getU(v[3]), sprite.getV(v[4]), 0.0f, 1.0f, 0.0f);
        }
    }

    private void drawProduct(VertexConsumer buffer, PoseStack poseStack, TextureAtlasSprite sprite, LoomBlockEntity loom, LoomRecipe recipe, int packedOverlay, int packedLight) {
        this.drawProduct(buffer, poseStack, sprite, (float)loom.getProgress() / (float)recipe.getStepCount(), packedOverlay, packedLight);
    }

    private void drawMaterial(VertexConsumer buffer, PoseStack poseStack, TextureAtlasSprite sprite, LoomBlockEntity loom, LoomRecipe recipe, float tileZ, int packedOverlay, int packedLight) {
        int maxPieces = recipe.getInputCount();
        float Z1 = loom.currentBoolean() ? tileZ : 0.0f;
        float Z2 = loom.currentBoolean() ? 0.0f : tileZ;
        float y1 = 0.9375f - 0.625f / (float)recipe.getStepCount() * (float)loom.getProgress();
        float z1 = 0.75f;
        for (int i = 0; i < loom.getCount(); ++i) {
            float y2;
            float z2;
            float texY2;
            float texX2;
            float texY1;
            float texX1;
            if (i % 2 == 0) {
                texX1 = 0.0f;
                texY1 = 0.0f;
                texX2 = 0.0625f;
                texY2 = 0.125f;
                z2 = 0.75f - Z1;
                y2 = 0.34375f;
            } else {
                texX1 = 0.125f;
                texY1 = 0.0f;
                texX2 = 0.1875f;
                texY2 = 0.1875f;
                z2 = 0.75f - Z2;
                y2 = 0.125f;
            }
            for (float[] v : RenderHelpers.getDiagonalPlaneVertices(0.1875f + 0.625f / (float)maxPieces * (float)i, y1, z1 - 0.001f, 0.1875f + 0.625f / (float)maxPieces * ((float)i + 1.0f), y2, z2 - 0.001f, texX1, texY1, texX2, texY2)) {
                RenderHelpers.renderTexturedVertex(poseStack, buffer, packedLight, packedOverlay, v[0], v[1], v[2], sprite.getU(v[3]), sprite.getV(v[4]), 0.0f, 1.0f, 0.0f);
            }
            if (i % 2 == 0) {
                texX1 = 0.0f;
            }
            texY1 = 0.5f;
            texY2 = 0.5625f;
            for (float[] v : RenderHelpers.getDiagonalPlaneVertices(0.1875f + 0.625f / (float)maxPieces * (float)i, 0.0f, z1 - 0.001f, 0.1875f + 0.625f / (float)maxPieces * (float)(i + 1), y2, z2 - 0.001f, texX1, texY1, texX2, texY2)) {
                RenderHelpers.renderTexturedVertex(poseStack, buffer, packedLight, packedOverlay, v[0], v[1], v[2], sprite.getU(v[3]), sprite.getV(v[4]), 0.0f, 1.0f, 0.0f);
            }
        }
    }
}

