/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.function.Function;
import net.dries007.tfc.client.RenderHelpers;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import org.jetbrains.annotations.Nullable;

public class SimpleMobRenderer<T extends Mob, M extends EntityModel<T>>
extends MobRenderer<T, M> {
    private final ResourceLocation texture;
    @Nullable
    private final ResourceLocation babyTexture;
    @Nullable
    private final Function<T, ResourceLocation> textureGetter;
    private final boolean doesFlop;
    private final float scale;

    public SimpleMobRenderer(EntityRendererProvider.Context ctx, M model, String name, float shadow, boolean flop, float scale, boolean hasBabyTexture, boolean itemInMouth, @Nullable Function<T, ResourceLocation> textureGetter) {
        super(ctx, model, shadow);
        this.doesFlop = flop;
        this.texture = RenderHelpers.animalTexture(name);
        this.babyTexture = hasBabyTexture ? RenderHelpers.animalTexture(name + "_young") : null;
        this.textureGetter = textureGetter != null ? textureGetter : e -> this.babyTexture != null && e.isBaby() ? this.babyTexture : this.texture;
        this.scale = scale;
    }

    protected void setupRotations(T entity, PoseStack poseStack, float bob, float yBodyRot, float partialTick, float scale) {
        super.setupRotations(entity, poseStack, bob, yBodyRot, partialTick, scale);
        if (this.doesFlop) {
            poseStack.mulPose(Axis.ZP.rotationDegrees(Mth.sin((float)(0.6f * bob))));
            if (!entity.isInWater()) {
                poseStack.translate(0.1f, 0.1f, -0.1f);
                poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
            }
        }
    }

    protected void scale(T entity, PoseStack poseStack, float scale) {
        float amount = entity.isBaby() ? this.scale * 0.7f : this.scale;
        poseStack.scale(amount, amount, amount);
        super.scale(entity, poseStack, scale);
    }

    public ResourceLocation getTextureLocation(T entity) {
        return this.textureGetter.apply(entity);
    }

    public static class Builder<T extends Mob, M extends EntityModel<T>> {
        private final EntityRendererProvider.Context ctx;
        private final Function<ModelPart, M> model;
        private final String name;
        private float shadow = 0.3f;
        private boolean flop = false;
        private float scale = 1.0f;
        private boolean hasBabyTexture = false;
        private boolean itemInMouth = false;
        @Nullable
        private Function<T, ResourceLocation> textureGetter = null;

        public Builder(EntityRendererProvider.Context ctx, Function<ModelPart, M> model, String name) {
            this.ctx = ctx;
            this.model = model;
            this.name = name;
        }

        public Builder<T, M> flops() {
            this.flop = true;
            return this;
        }

        public Builder<T, M> shadow(float size) {
            this.shadow = size;
            return this;
        }

        public Builder<T, M> scale(float scale) {
            this.scale = scale;
            return this;
        }

        public Builder<T, M> hasBabyTexture() {
            this.hasBabyTexture = true;
            return this;
        }

        public Builder<T, M> mouthy() {
            this.itemInMouth = true;
            return this;
        }

        public Builder<T, M> texture(Function<T, ResourceLocation> getter) {
            this.textureGetter = getter;
            return this;
        }

        public SimpleMobRenderer<T, M> build() {
            return new SimpleMobRenderer<T, EntityModel>(this.ctx, (EntityModel)this.model.apply(RenderHelpers.bakeSimple(this.ctx, this.name)), this.name, this.shadow, this.flop, this.scale, this.hasBabyTexture, this.itemInMouth, this.textureGetter);
        }
    }
}

