/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.client.render.entity.TFCBoatRenderer;
import net.dries007.tfc.common.entities.misc.TFCChestBoat;
import net.dries007.tfc.common.items.ChestBlockItem;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.ChestRaftModel;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.joml.Quaternionf;

public class TFCChestBoatRenderer
extends TFCBoatRenderer {
    private static final ResourceLocation DEFAULT_TEXTURE = Helpers.identifier("textures/entity/chest_boat/oak.png");
    private final ListModel<Boat> model;

    public static ModelLayerLocation chestBoatName(String name) {
        return RenderHelpers.layerId("chest_boat/" + name);
    }

    public TFCChestBoatRenderer(EntityRendererProvider.Context context, String name) {
        super(context, name);
        ModelPart part = context.bakeLayer(TFCChestBoatRenderer.chestBoatName(name));
        this.model = name.equals("palm") ? new ChestRaftModel(part) : new ChestBoatModel(part);
    }

    public TFCChestBoatRenderer(EntityRendererProvider.Context context, Pair<ResourceLocation, ListModel<Boat>> originalPair, BoatModel model) {
        super(context, originalPair);
        this.model = model;
    }

    public void render(Boat boat, float ageInTicks, float pitch, PoseStack poseStack, MultiBufferSource buffers, int packedLight) {
        if (boat instanceof TFCChestBoat) {
            float f2;
            TFCChestBoat chest = (TFCChestBoat)boat;
            poseStack.pushPose();
            poseStack.translate(0.0f, 0.375f, 0.0f);
            poseStack.mulPose(Axis.YP.rotationDegrees(180.0f - ageInTicks));
            float f = (float)boat.getHurtTime() - pitch;
            float f1 = boat.getDamage() - pitch;
            if (f1 < 0.0f) {
                f1 = 0.0f;
            }
            if (f > 0.0f) {
                poseStack.mulPose(Axis.XP.rotationDegrees(Mth.sin((float)f) * f * f1 / 10.0f * (float)boat.getHurtDir()));
            }
            if (!Mth.equal((float)(f2 = boat.getBubbleAngle(pitch)), (float)0.0f)) {
                poseStack.mulPose(new Quaternionf().setAngleAxis(boat.getBubbleAngle(pitch) * ((float)Math.PI / 180), 1.0f, 0.0f, 1.0f));
            }
            poseStack.scale(-1.0f, -1.0f, 1.0f);
            poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
            this.model.setupAnim((Entity)chest, pitch, 0.0f, -0.1f, 0.0f, 0.0f);
            VertexConsumer vertexconsumer = buffers.getBuffer(this.model.renderType(this.getChestTexture(chest)));
            this.model.renderToBuffer(poseStack, vertexconsumer, packedLight, OverlayTexture.NO_OVERLAY, -1);
            poseStack.popPose();
        }
        super.render(boat, ageInTicks, pitch, poseStack, buffers, packedLight);
    }

    protected ResourceLocation getChestTexture(TFCChestBoat chest) {
        ResourceLocation resourceLocation;
        ItemStack stack = chest.getChestItem();
        Item item = stack.getItem();
        if (item instanceof ChestBlockItem) {
            ChestBlockItem item2 = (ChestBlockItem)item;
            resourceLocation = item2.getBoatTexture();
        } else {
            resourceLocation = DEFAULT_TEXTURE;
        }
        return resourceLocation;
    }
}

