/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.screen;

import net.dries007.tfc.client.ClientHelpers;
import net.dries007.tfc.client.ClimateRenderCache;
import net.dries007.tfc.client.screen.TFCContainerScreen;
import net.dries007.tfc.client.screen.button.PlayerInventoryTabButton;
import net.dries007.tfc.common.container.Container;
import net.dries007.tfc.compat.patchouli.PatchouliIntegration;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.config.TemperatureDisplayStyle;
import net.dries007.tfc.network.SwitchInventoryTabPacket;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.climate.KoppenClimateClassification;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.neoforge.network.PacketDistributor;

public class ClimateScreen
extends TFCContainerScreen<Container> {
    public static final ResourceLocation BACKGROUND = Helpers.identifier("textures/gui/player_climate.png");

    public ClimateScreen(Container container, Inventory playerInv, Component name) {
        super(container, playerInv, name, BACKGROUND);
    }

    public void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)new PlayerInventoryTabButton(this.leftPos, this.topPos, false, false, PlayerInventoryTabButton.Tab.INVENTORY, button -> {
            this.playerInventory.player.containerMenu = this.playerInventory.player.inventoryMenu;
            Minecraft.getInstance().setScreen((Screen)new InventoryScreen(this.playerInventory.player));
            PacketDistributor.sendToServer((CustomPacketPayload)new SwitchInventoryTabPacket(PlayerInventoryTabButton.Tab.INVENTORY), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }));
        this.addRenderableWidget((GuiEventListener)new PlayerInventoryTabButton(this.leftPos, this.topPos, false, false, PlayerInventoryTabButton.Tab.CALENDAR));
        this.addRenderableWidget((GuiEventListener)new PlayerInventoryTabButton(this.leftPos, this.topPos, false, false, PlayerInventoryTabButton.Tab.NUTRITION));
        this.addRenderableWidget((GuiEventListener)new PlayerInventoryTabButton(this.leftPos, this.topPos, true, false, PlayerInventoryTabButton.Tab.CLIMATE, button -> {}));
        PatchouliIntegration.ifEnabled(() -> this.addRenderableWidget((GuiEventListener)new PlayerInventoryTabButton(this.leftPos, this.topPos, false, false, PlayerInventoryTabButton.Tab.BOOK)));
    }

    protected void renderLabels(GuiGraphics stack, int mouseX, int mouseY) {
        super.renderLabels(stack, mouseX, mouseY);
        float averageTemp = ClimateRenderCache.INSTANCE.getAverageTemperature();
        float averageRainfall = ClimateRenderCache.INSTANCE.getAverageRainfall();
        float rainVar = ClimateRenderCache.INSTANCE.getRainVariance();
        float currentTemp = ClimateRenderCache.INSTANCE.getTemperature();
        float currentRainfall = ClimateRenderCache.INSTANCE.getRainfall();
        TemperatureDisplayStyle style = TFCConfig.CLIENT.climateTooltipStyle.get();
        this.drawLine(stack, (Component)Helpers.translateEnum(KoppenClimateClassification.classify(averageTemp, averageRainfall, rainVar, ClientHelpers.inNorthernHemisphere())), TFCContainerScreen.TextAlignment.CENTER, 18);
        this.drawLine(stack, (Component)Component.translatable((String)"tfc.tooltip.climate_temperature_name"), TFCContainerScreen.TextAlignment.LEFT, 32);
        this.drawLine(stack, (Component)Component.translatable((String)"tfc.tooltip.climate_temperature_average", (Object[])new Object[]{style.formatRange(averageTemp)}), TFCContainerScreen.TextAlignment.LEFT, -1, 36, 32);
        this.drawLine(stack, (Component)Component.translatable((String)"tfc.tooltip.climate_temperature_now", (Object[])new Object[]{style.formatRange(currentTemp)}), TFCContainerScreen.TextAlignment.LEFT, -1, 96, 32);
        this.drawLine(stack, (Component)Component.translatable((String)"tfc.tooltip.climate_rainfall_name"), TFCContainerScreen.TextAlignment.LEFT, 0x202080, 46);
        this.drawLine(stack, (Component)Component.translatable((String)"tfc.tooltip.climate_rainfall_average", (Object[])new Object[]{String.format("%.0f", Float.valueOf(averageRainfall))}), TFCContainerScreen.TextAlignment.LEFT, 0x202080, 36, 46);
        this.drawLine(stack, (Component)Component.translatable((String)"tfc.tooltip.climate_rainfall_now", (Object[])new Object[]{String.format("%.0f", Float.valueOf(currentRainfall))}), TFCContainerScreen.TextAlignment.LEFT, 0x202080, 96, 46);
        this.drawLine(stack, (Component)Component.translatable((String)"tfc.tooltip.climate_peak_rainfall"), TFCContainerScreen.TextAlignment.LEFT, 0x202080, 57);
        this.drawLine(stack, (Component)Component.translatable((String)(rainVar > 0.0f ? "tfc.tooltip.climate_peak_rainfall_july" : "tfc.tooltip.climate_peak_rainfall_january"), (Object[])new Object[]{String.format("%.0f", Float.valueOf(averageRainfall * (1.0f + Math.abs(rainVar))))}), TFCContainerScreen.TextAlignment.LEFT, 0x202080, 36, 57);
    }
}

