/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.screen;

import net.dries007.tfc.client.ClientHelpers;
import net.dries007.tfc.client.screen.TFCContainerScreen;
import net.dries007.tfc.client.screen.button.PlayerInventoryTabButton;
import net.dries007.tfc.common.component.food.INutritionData;
import net.dries007.tfc.common.component.food.Nutrient;
import net.dries007.tfc.common.container.Container;
import net.dries007.tfc.common.player.IPlayerInfo;
import net.dries007.tfc.compat.patchouli.PatchouliIntegration;
import net.dries007.tfc.network.SwitchInventoryTabPacket;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;

public class NutritionScreen
extends TFCContainerScreen<Container> {
    public static final ResourceLocation TEXTURE = Helpers.identifier("textures/gui/player_nutrition.png");

    public NutritionScreen(Container container, Inventory playerInventory, Component name) {
        super(container, playerInventory, name, TEXTURE);
    }

    public void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)new PlayerInventoryTabButton(this.leftPos, this.topPos, false, false, PlayerInventoryTabButton.Tab.INVENTORY, button -> {
            this.playerInventory.player.containerMenu = this.playerInventory.player.inventoryMenu;
            Minecraft.getInstance().setScreen((Screen)new InventoryScreen(this.playerInventory.player));
            PacketDistributor.sendToServer((CustomPacketPayload)new SwitchInventoryTabPacket(PlayerInventoryTabButton.Tab.INVENTORY), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }));
        this.addRenderableWidget((GuiEventListener)new PlayerInventoryTabButton(this.leftPos, this.topPos, false, false, PlayerInventoryTabButton.Tab.CALENDAR));
        this.addRenderableWidget((GuiEventListener)new PlayerInventoryTabButton(this.leftPos, this.topPos, true, false, PlayerInventoryTabButton.Tab.NUTRITION));
        this.addRenderableWidget((GuiEventListener)new PlayerInventoryTabButton(this.leftPos, this.topPos, false, false, PlayerInventoryTabButton.Tab.CLIMATE));
        PatchouliIntegration.ifEnabled(() -> this.addRenderableWidget((GuiEventListener)new PlayerInventoryTabButton(this.leftPos, this.topPos, false, false, PlayerInventoryTabButton.Tab.BOOK)));
    }

    @Override
    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(graphics, partialTicks, mouseX, mouseY);
        Player player = ClientHelpers.getPlayer();
        if (player != null) {
            INutritionData nutrition = IPlayerInfo.get(player).nutrition();
            for (Nutrient nutrient : Nutrient.VALUES) {
                int width = (int)(nutrition.getNutrient(nutrient) * 93.0f);
                graphics.blit(this.texture, this.leftPos + 76, this.topPos + 18 + 11 * nutrient.ordinal(), 0, 166, width, 5);
            }
        }
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        super.renderLabels(graphics, mouseX, mouseY);
        for (Nutrient nutrient : Nutrient.VALUES) {
            MutableComponent text = Helpers.translateEnum(nutrient);
            this.drawLine(graphics, (Component)text, TFCContainerScreen.TextAlignment.RIGHT, -1, 105, 17 + 11 * nutrient.ordinal());
        }
    }
}

