/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.screen.button;

import net.dries007.tfc.client.ClientHelpers;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.client.screen.AnvilScreen;
import net.dries007.tfc.common.blockentities.AnvilBlockEntity;
import net.dries007.tfc.common.recipes.AnvilRecipe;
import net.dries007.tfc.network.ScreenButtonPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class AnvilPlanButton
extends Button {
    private final AnvilBlockEntity anvil;

    public AnvilPlanButton(AnvilBlockEntity anvil, int guiLeft, int guiTop) {
        super(guiLeft + 21, guiTop + 40, 18, 18, (Component)Component.translatable((String)"tfc.tooltip.anvil_plan"), button -> PacketDistributor.sendToServer((CustomPacketPayload)new ScreenButtonPacket(8), (CustomPacketPayload[])new CustomPacketPayload[0]), RenderHelpers.NARRATION);
        this.setTooltip(Tooltip.create((Component)Component.translatable((String)"tfc.tooltip.anvil_plan")));
        this.anvil = anvil;
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        int x = this.getX();
        int y = this.getY();
        graphics.blit(AnvilScreen.BACKGROUND, x, y, 218.0f, 0.0f, this.width, this.height, 256, 256);
        AnvilRecipe recipe = this.getRecipe();
        if (recipe != null) {
            RegistryAccess access = ClientHelpers.getLevelOrThrow().registryAccess();
            graphics.renderItem(recipe.getResultItem((HolderLookup.Provider)access), x + 1, y + 1);
            graphics.renderItemDecorations(Minecraft.getInstance().font, recipe.getResultItem((HolderLookup.Provider)access), x + 1, y + 1);
        } else {
            boolean workable = this.anvil.getLevel() != null && AnvilRecipe.hasAny(this.anvil.getLevel(), ((AnvilBlockEntity.AnvilInventory)this.anvil.getInventory()).getStackInSlot(0), this.anvil.getTier());
            graphics.blit(AnvilScreen.BACKGROUND, x + 1, y + 1, workable ? 236.0f : 219.0f, workable ? 0.0f : 51.0f, 16, 16, 256, 256);
        }
    }

    @Nullable
    private AnvilRecipe getRecipe() {
        return this.anvil.getMainInputForging().getRecipe();
    }
}

