/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.screen.button;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Objects;
import net.dries007.tfc.client.ClientHelpers;
import net.dries007.tfc.client.ClimateRenderCache;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.config.TemperatureDisplayStyle;
import net.dries007.tfc.network.SwitchInventoryTabPacket;
import net.dries007.tfc.util.calendar.Calendars;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.PacketDistributor;

public class PlayerInventoryTabButton
extends Button {
    private final int textureU;
    private final int textureV;
    private int iconX;
    private int iconY;
    private int prevGuiLeft;
    private int prevGuiTop;
    private final Tab tab;
    private Runnable tickCallback;
    private final boolean active;
    private final boolean detached;

    public PlayerInventoryTabButton(int guiLeft, int guiTop, boolean active, boolean detached, Tab tab) {
        this(guiLeft, guiTop, active, detached, tab, button -> PacketDistributor.sendToServer((CustomPacketPayload)new SwitchInventoryTabPacket(tab), (CustomPacketPayload[])new CustomPacketPayload[0]));
    }

    public PlayerInventoryTabButton(int guiLeft, int guiTop, boolean active, boolean detached, Tab tab, Button.OnPress onPressIn) {
        super(detached ? guiLeft + tab.xIn + 110 : guiLeft + tab.xIn + (active ? -3 : -2), detached ? guiTop + tab.yIn + 5 : guiTop + tab.yIn, 24, 22, (Component)Component.empty(), onPressIn, RenderHelpers.NARRATION);
        this.prevGuiLeft = guiLeft;
        this.prevGuiTop = guiTop;
        this.textureU = detached ? (active ? 72 : 48) : (active ? 24 : 0);
        this.textureV = 16;
        this.iconX = detached ? guiLeft + tab.xIn + 113 + 1 : guiLeft + tab.xIn + 1;
        this.iconY = detached ? guiTop + tab.yIn + 4 + 4 : guiTop + tab.yIn + 3;
        this.tickCallback = () -> {};
        this.tab = tab;
        this.active = active;
        this.detached = detached;
    }

    public PlayerInventoryTabButton setRecipeBookCallback(final InventoryScreen screen) {
        this.tickCallback = new Runnable(){
            boolean recipeBookVisible;
            {
                this.recipeBookVisible = screen.getRecipeBookComponent().isVisible();
            }

            @Override
            public void run() {
                boolean newRecipeBookVisible = screen.getRecipeBookComponent().isVisible();
                if (newRecipeBookVisible != this.recipeBookVisible) {
                    this.recipeBookVisible = newRecipeBookVisible;
                    PlayerInventoryTabButton.this.updateGuiSize(screen.getGuiLeft(), screen.getGuiTop());
                }
            }
        };
        return this;
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.tickCallback.run();
        graphics.blit(ClientHelpers.GUI_ICONS, this.getX(), this.getY(), 0, (float)this.textureU, (float)this.textureV, this.width, this.height, 256, 256);
        graphics.blit(ClientHelpers.GUI_ICONS, this.iconX, this.iconY, 16, 16, (float)this.tab.iconU, (float)this.tab.iconV, 16, 16, 256, 256);
        if (this.isHovered() && !this.active) {
            Font font = Minecraft.getInstance().font;
            switch (this.tab.ordinal()) {
                case 0: {
                    MutableComponent title = Component.translatable((String)"container.inventory");
                    graphics.renderTooltip(font, (Component)title, mouseX, mouseY);
                    break;
                }
                case 1: {
                    MutableComponent title = Component.translatable((String)"tfc.screen.calendar");
                    MutableComponent hoverText = Calendars.CLIENT.getDayTime();
                    graphics.renderComponentTooltip(font, List.of(title, hoverText), mouseX, mouseY);
                    break;
                }
                case 2: {
                    MutableComponent title = Component.translatable((String)"tfc.screen.nutrition");
                    graphics.renderTooltip(font, (Component)title, mouseX, mouseY);
                    break;
                }
                case 3: {
                    TemperatureDisplayStyle style = TFCConfig.CLIENT.climateTooltipStyle.get();
                    MutableComponent title = Component.translatable((String)"tfc.screen.climate");
                    Component hoverText = (Component)Objects.requireNonNull(style.formatRange(ClimateRenderCache.INSTANCE.getTemperature()));
                    graphics.renderComponentTooltip(font, List.of(title, hoverText), mouseX, mouseY);
                    break;
                }
                case 4: {
                    MutableComponent hoverText = Component.translatable((String)"tfc.tab.field_guide");
                    graphics.renderTooltip(font, (Component)hoverText, mouseX, mouseY);
                }
            }
        }
    }

    public void updateGuiSize(int guiLeft, int guiTop) {
        this.setX(this.getX() + guiLeft - this.prevGuiLeft);
        this.setY(this.getY() + guiTop - this.prevGuiTop);
        this.iconX += guiLeft - this.prevGuiLeft;
        this.iconY += guiTop - this.prevGuiTop;
        this.prevGuiLeft = guiLeft;
        this.prevGuiTop = guiTop;
    }

    public static enum Tab {
        INVENTORY(0, 0, 176, 4),
        CALENDAR(16, 0, 176, 27),
        NUTRITION(32, 0, 176, 50),
        CLIMATE(48, 0, 176, 73),
        BOOK(64, 0, 176, 96);

        public final int iconU;
        public final int iconV;
        public final int xIn;
        public final int yIn;
        public static final Tab[] VALUES;
        public static final StreamCodec<ByteBuf, Tab> STREAM;

        private Tab(int iconU, int iconV, int xIn, int yIn) {
            this.iconU = iconU;
            this.iconV = iconV;
            this.xIn = xIn;
            this.yIn = yIn;
        }

        static {
            VALUES = Tab.values();
            STREAM = ByteBufCodecs.BYTE.map(c -> VALUES[c], c -> (byte)c.ordinal());
        }
    }
}

