/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TickCounterBlockEntity;
import net.dries007.tfc.common.blockentities.TickingPlantBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class BerryBushBlockEntity
extends TickingPlantBlockEntity {
    private int growthsRemaining = 24;

    public static void reset(Level level, BlockPos pos) {
        level.getBlockEntity(pos, (BlockEntityType)TFCBlockEntities.BERRY_BUSH.get()).ifPresent(TickCounterBlockEntity::resetCounter);
    }

    public static void resetPickedTick(Level level, BlockPos pos) {
        level.getBlockEntity(pos, (BlockEntityType)TFCBlockEntities.BERRY_BUSH.get()).ifPresent(TickingPlantBlockEntity::resetLastPickedCounter);
    }

    protected BerryBushBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)TFCBlockEntities.BERRY_BUSH.get(), pos, state);
    }

    protected BerryBushBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        this.growthsRemaining = nbt.getInt("growthsRemaining");
        super.loadAdditional(nbt, provider);
    }

    @Override
    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        nbt.putInt("growthsRemaining", this.growthsRemaining);
        super.saveAdditional(nbt, provider);
    }

    public void decreaseGrowthsRemaining(int amount) {
        this.growthsRemaining -= amount;
        this.setChanged();
    }

    public void setGrowthsRemaining(int growths) {
        this.growthsRemaining = growths;
        this.setChanged();
    }

    public int getGrowthsRemaining() {
        return this.growthsRemaining;
    }
}

