/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.dries007.tfc.common.blockentities.IRecipeTimer;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TickableBlockEntity;
import net.dries007.tfc.common.blocks.BloomBlock;
import net.dries007.tfc.common.blocks.MoltenBlock;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.devices.BloomeryBlock;
import net.dries007.tfc.common.component.heat.HeatCapability;
import net.dries007.tfc.common.recipes.BloomeryRecipe;
import net.dries007.tfc.common.recipes.HeatingRecipe;
import net.dries007.tfc.common.recipes.RecipeHelpers;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.CalendarTransaction;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.ICalendarTickable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class BloomeryBlockEntity
extends TickableBlockEntity
implements ICalendarTickable,
IRecipeTimer {
    protected final List<ItemStack> inputStacks;
    private long lastPlayerTick = Integer.MIN_VALUE;
    private long litTick;
    @Nullable
    protected BloomeryRecipe cachedRecipe;

    public static void serverTick(Level level, BlockPos pos, BlockState state, BloomeryBlockEntity bloomery) {
        bloomery.checkForLastTickSync();
        bloomery.checkForCalendarUpdate();
        if (level.getGameTime() % 20L == 0L) {
            boolean lit;
            if (((Boolean)state.getValue((Property)BloomeryBlock.LIT)).booleanValue() && bloomery.getRemainingTicks() <= 0L) {
                bloomery.completeRecipe();
                state = (BlockState)state.setValue((Property)BloomeryBlock.LIT, (Comparable)Boolean.valueOf(false));
            }
            Direction direction = (Direction)state.getValue((Property)BloomeryBlock.FACING);
            int capacity = bloomery.calculateCapacity();
            boolean modified = bloomery.inputStacks.size() > capacity;
            bloomery.popItemsOffOverCapacity(bloomery.inputStacks, capacity);
            if (modified) {
                if (((Boolean)state.getValue((Property)BloomeryBlock.LIT)).booleanValue()) {
                    state = (BlockState)state.setValue((Property)BloomeryBlock.LIT, (Comparable)Boolean.valueOf(false));
                    level.setBlockAndUpdate(pos, state);
                }
                if (!BloomeryBlock.canGateStayInPlace((LevelAccessor)level, pos, direction.getAxis())) {
                    level.destroyBlock(pos, true);
                    return;
                }
                bloomery.markForSync();
            }
            if (!(lit = ((Boolean)state.getValue((Property)BloomeryBlock.LIT)).booleanValue())) {
                bloomery.addItemsFromWorld(capacity);
            }
            MoltenBlock.manageMoltenBlockTower(level, bloomery.getInternalBlockPos(), lit, TFCConfig.SERVER.bloomeryMaxChimneyHeight.get(), bloomery.inputStacks.size(), TFCConfig.SERVER.bloomeryCapacity.get());
        }
    }

    public BloomeryBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFCBlockEntities.BLOOMERY.get(), pos, state);
        this.inputStacks = new ArrayList<ItemStack>();
    }

    @Override
    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        Helpers.readItemStacksFromNbt(provider, this.inputStacks, nbt.getList("inputStacks", 10));
        this.litTick = nbt.getLong("litTick");
        this.lastPlayerTick = nbt.getLong("lastTick");
        super.loadAdditional(nbt, provider);
    }

    @Override
    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        nbt.put("inputStacks", (Tag)Helpers.writeItemStacksToNbt(provider, this.inputStacks));
        nbt.putLong("litTick", this.litTick);
        nbt.putLong("lastTick", this.lastPlayerTick);
        super.saveAdditional(nbt, provider);
    }

    public long getRemainingTicks() {
        if (this.cachedRecipe == null) {
            this.updateCachedRecipe();
        }
        if (this.cachedRecipe != null) {
            return (long)this.cachedRecipe.getDuration() - this.getTicksSinceLit();
        }
        return 0L;
    }

    public long getTicksSinceLit() {
        assert (this.level != null);
        return Calendars.get((LevelReader)this.level).getTicks() - this.litTick;
    }

    @Nullable
    public BloomeryRecipe getCachedRecipe() {
        return this.cachedRecipe;
    }

    public BlockPos getInternalBlockPos() {
        assert (this.level != null);
        BlockState state = this.level.getBlockState(this.worldPosition);
        if (state.hasProperty((Property)BloomeryBlock.FACING)) {
            return this.worldPosition.relative(((Direction)state.getValue((Property)BloomeryBlock.FACING)).getOpposite());
        }
        return this.worldPosition;
    }

    public BlockPos getExternalBlock() {
        assert (this.level != null);
        BlockState state = this.level.getBlockState(this.worldPosition);
        if (state.hasProperty((Property)BloomeryBlock.FACING)) {
            return this.worldPosition.relative((Direction)state.getValue((Property)BloomeryBlock.FACING));
        }
        return this.worldPosition;
    }

    public boolean light(BlockState state) {
        assert (this.level != null);
        if (((Boolean)state.getValue((Property)BloomeryBlock.LIT)).booleanValue()) {
            return true;
        }
        this.updateCachedRecipe();
        if (this.cachedRecipe != null) {
            this.litTick = Calendars.get((LevelReader)this.level).getTicks();
            state = (BlockState)((BlockState)state.setValue((Property)BloomeryBlock.LIT, (Comparable)Boolean.valueOf(true))).setValue((Property)BloomeryBlock.OPEN, (Comparable)Boolean.valueOf(false));
            this.level.setBlockAndUpdate(this.worldPosition, state);
            return true;
        }
        return false;
    }

    public int getInputCount() {
        return this.inputStacks.size();
    }

    public List<ItemStack> getInputStacks() {
        return this.inputStacks;
    }

    public void ejectInventory() {
        this.dumpItems();
        this.destroyMolten();
    }

    @Override
    public void onCalendarUpdate(long ticks) {
        assert (this.level != null);
        if (this.cachedRecipe == null) {
            this.updateCachedRecipe();
        }
        if (this.level.isClientSide || this.cachedRecipe == null || !((Boolean)this.level.getBlockState(this.worldPosition).getValue((Property)BloomeryBlock.LIT)).booleanValue()) {
            return;
        }
        long finishTick = (long)this.cachedRecipe.getDuration() + this.litTick;
        if (finishTick <= Calendars.SERVER.getTicks()) {
            long offset = Calendars.SERVER.getTicks() - finishTick;
            try (CalendarTransaction tr = Calendars.SERVER.transaction();){
                tr.add(-offset);
                this.completeRecipe();
            }
        }
    }

    @Override
    @Deprecated
    public long getLastCalendarUpdateTick() {
        return this.lastPlayerTick;
    }

    @Override
    @Deprecated
    public void setLastCalendarUpdateTick(long tick) {
        this.lastPlayerTick = tick;
    }

    @Override
    public int getRecipeDuration() {
        return this.cachedRecipe != null ? this.cachedRecipe.getDuration() : 0;
    }

    @Override
    public long getRemainingTime() {
        return this.getRemainingTicks();
    }

    private void dumpItems() {
        assert (this.level != null);
        BlockPos pos = this.getExternalBlock();
        for (ItemStack stack : this.inputStacks) {
            Containers.dropItemStack((Level)this.level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)stack);
        }
        this.cachedRecipe = null;
        this.inputStacks.clear();
    }

    private void popItemsOffOverCapacity(List<ItemStack> items, int capacity) {
        assert (this.level != null);
        while (items.size() > capacity) {
            Helpers.spawnItem(this.level, this.worldPosition, items.remove(items.size() - 1));
        }
    }

    private void addItemsFromWorld(int capacity) {
        block12: {
            block14: {
                ArrayList<ItemEntity> foundInputs;
                ArrayList<ItemEntity> foundCatalysts;
                block13: {
                    assert (this.level != null);
                    this.updateCachedRecipe();
                    if (this.cachedRecipe == null && !this.inputStacks.isEmpty()) {
                        this.dumpItems();
                        this.markForSync();
                    }
                    if (this.inputStacks.size() == capacity) {
                        return;
                    }
                    BlockPos internalPos = this.getInternalBlockPos();
                    List itemEntities = this.level.getEntitiesOfClass(ItemEntity.class, AABB.encapsulatingFullBlocks((BlockPos)internalPos, (BlockPos)internalPos.offset(1, BloomeryBlock.getChimneyLevels(this.level, internalPos) + 1, 1)), EntitySelector.ENTITY_STILL_ALIVE);
                    if (this.cachedRecipe == null) {
                        assert (this.inputStacks.isEmpty());
                        Collection recipes = RecipeHelpers.getRecipes(this.level, TFCRecipeTypes.BLOOMERY);
                        block0: for (ItemEntity entity : itemEntities) {
                            @Nullable HeatingRecipe heat = HeatingRecipe.getRecipe(entity.getItem());
                            if (heat == null) continue;
                            FluidStack fluid = heat.assembleFluid(entity.getItem());
                            for (RecipeHolder recipe : recipes) {
                                if (!((BloomeryRecipe)recipe.value()).matchesInput(fluid)) continue;
                                this.cachedRecipe = (BloomeryRecipe)recipe.value();
                                this.markForSync();
                                break block0;
                            }
                        }
                    }
                    if (this.cachedRecipe == null) break block12;
                    foundCatalysts = new ArrayList<ItemEntity>();
                    foundInputs = new ArrayList<ItemEntity>();
                    for (ItemEntity entity : itemEntities) {
                        ItemStack stack = entity.getItem();
                        if (this.cachedRecipe.matchesInput(stack)) {
                            foundInputs.add(entity);
                            continue;
                        }
                        if (!this.cachedRecipe.matchesCatalyst(stack)) continue;
                        foundCatalysts.add(entity);
                    }
                    if (!foundCatalysts.isEmpty() && !foundInputs.isEmpty()) break block13;
                    if (this.inputStacks.isEmpty()) break block14;
                    if (!foundCatalysts.isEmpty()) break block13;
                    if (!foundInputs.isEmpty()) break block14;
                }
                Helpers.alternatingConsumeItemsFromEntitiesIndividually(foundCatalysts, foundInputs, capacity - this.inputStacks.size(), this.inputStacks::add);
            }
            this.markForSync();
        }
    }

    private void destroyMolten() {
        assert (this.level != null);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            MoltenBlock.removeMoltenBlockTower(this.level, this.worldPosition.relative(direction), TFCConfig.SERVER.bloomeryMaxChimneyHeight.get());
        }
    }

    private int calculateCapacity() {
        Direction direction;
        assert (this.level != null);
        BlockPos pos = this.getInternalBlockPos();
        if (BloomeryBlock.isFormed(this.level, pos, direction = (Direction)this.getBlockState().getValue((Property)BloomeryBlock.FACING))) {
            return BloomeryBlock.getChimneyLevels(this.level, pos) * TFCConfig.SERVER.bloomeryCapacity.get();
        }
        return 0;
    }

    private void completeRecipe() {
        assert (this.level != null);
        if (this.cachedRecipe != null) {
            int fluidAmount = 0;
            int catalystAmount = 0;
            for (ItemStack stack : this.inputStacks) {
                @Nullable FluidStack primaryInput = this.cachedRecipe.consumeInput(stack);
                if (primaryInput != null) {
                    fluidAmount += primaryInput.getAmount();
                    continue;
                }
                ++catalystAmount;
            }
            int producedAmount = Math.min(fluidAmount / this.cachedRecipe.getInputFluid().amount(), catalystAmount / this.cachedRecipe.getCatalyst().count());
            if (producedAmount > 0) {
                ItemStack outputStack = this.cachedRecipe.assembleOutput();
                @Nullable HeatingRecipe recipe = HeatingRecipe.getRecipe(outputStack);
                if (recipe != null) {
                    HeatCapability.setTemperature(outputStack, recipe.getTemperature() - 1.0f);
                }
                BlockPos pos = this.getInternalBlockPos();
                this.level.setBlockAndUpdate(pos, (BlockState)((Block)TFCBlocks.BLOOM.get()).defaultBlockState().setValue((Property)BloomBlock.LAYERS, (Comparable)Integer.valueOf(8)));
                this.level.getBlockEntity(pos, (BlockEntityType)TFCBlockEntities.BLOOM.get()).ifPresent(bloom -> bloom.setBloom(outputStack, producedAmount));
            }
        }
        this.inputStacks.clear();
        this.cachedRecipe = null;
        this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)BloomeryBlock.LIT, (Comparable)Boolean.valueOf(false)));
        this.destroyMolten();
    }

    private void updateCachedRecipe() {
        assert (this.level != null);
        this.cachedRecipe = null;
        Collection recipes = RecipeHelpers.getRecipes(this.level, TFCRecipeTypes.BLOOMERY);
        for (ItemStack stack : this.inputStacks) {
            @Nullable HeatingRecipe heat = HeatingRecipe.getRecipe(stack);
            if (heat == null) continue;
            FluidStack fluid = heat.assembleFluid(stack);
            for (RecipeHolder recipe : recipes) {
                if (!((BloomeryRecipe)recipe.value()).matchesInput(fluid)) continue;
                this.cachedRecipe = (BloomeryRecipe)recipe.value();
                return;
            }
        }
    }
}

