/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TickCounterBlockEntity;
import net.dries007.tfc.common.blocks.CharcoalPileBlock;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BurningLogPileBlockEntity
extends TickCounterBlockEntity {
    private int logs;

    public static void serverTick(Level level, BlockPos pos, BlockState state, BurningLogPileBlockEntity entity) {
        if (entity.lastUpdateTick > 0L && entity.getTicksSinceUpdate() > (long)TFCConfig.SERVER.charcoalTicks.get().intValue()) {
            entity.createCharcoal();
        }
    }

    public BurningLogPileBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFCBlockEntities.BURNING_LOG_PILE.get(), pos, state);
    }

    @Override
    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        this.logs = nbt.getInt("logs");
        super.loadAdditional(nbt, provider);
    }

    @Override
    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        nbt.putInt("logs", this.logs);
        super.saveAdditional(nbt, provider);
    }

    public void light(int logs) {
        this.logs = logs;
        this.resetCounter();
        this.markForSync();
    }

    public int getLogs() {
        return this.logs;
    }

    private void createCharcoal() {
        int currentAmount;
        int amount;
        if (this.level == null) {
            return;
        }
        if (BurningLogPileBlockEntity.isPileBlock(this.level.getBlockState(this.worldPosition.above()))) {
            return;
        }
        int charcoal = BurningLogPileBlockEntity.getCharcoalAmount(this.level, this.logs);
        int height = 1;
        BlockPos.MutableBlockPos currentPos = this.worldPosition.mutable().move(Direction.DOWN);
        BlockState currentState = this.level.getBlockState((BlockPos)currentPos);
        while (Helpers.isBlock(currentState, (Block)TFCBlocks.BURNING_LOG_PILE.get())) {
            ++height;
            int logs = this.level.getBlockEntity((BlockPos)currentPos, (BlockEntityType)TFCBlockEntities.BURNING_LOG_PILE.get()).map(BurningLogPileBlockEntity::getLogs).orElse(0);
            charcoal += BurningLogPileBlockEntity.getCharcoalAmount(this.level, logs);
            currentPos.move(Direction.DOWN);
            currentState = this.level.getBlockState((BlockPos)currentPos);
        }
        currentPos.set((Vec3i)this.worldPosition).move(0, 1 - height, 0);
        BlockState belowState = this.level.getBlockState(currentPos.below());
        if (Helpers.isBlock(belowState, (Block)TFCBlocks.CHARCOAL_PILE.get()) && (amount = Mth.clamp((int)charcoal, (int)0, (int)(8 - (currentAmount = ((Integer)belowState.getValue((Property)CharcoalPileBlock.LAYERS)).intValue())))) > 0) {
            charcoal -= amount;
            this.level.setBlockAndUpdate(currentPos.below(), (BlockState)belowState.setValue((Property)CharcoalPileBlock.LAYERS, (Comparable)Integer.valueOf(currentAmount + amount)));
        }
        for (int i = 0; i < height; ++i) {
            if (charcoal > 0) {
                amount = Mth.clamp((int)charcoal, (int)0, (int)8);
                charcoal -= amount;
                this.level.setBlockAndUpdate((BlockPos)currentPos, (BlockState)((Block)TFCBlocks.CHARCOAL_PILE.get()).defaultBlockState().setValue((Property)CharcoalPileBlock.LAYERS, (Comparable)Integer.valueOf(amount)));
            } else {
                this.level.setBlockAndUpdate((BlockPos)currentPos, Blocks.AIR.defaultBlockState());
            }
            currentPos.move(Direction.UP);
        }
    }

    private static int getCharcoalAmount(Level level, int logs) {
        return (int)Mth.clamp((double)((double)logs * (0.25 + 0.25 * (double)level.getRandom().nextFloat())), (double)0.0, (double)8.0);
    }

    private static boolean isPileBlock(BlockState state) {
        return Helpers.isBlock(state, (Block)TFCBlocks.CHARCOAL_PILE.get()) || Helpers.isBlock(state, (Block)TFCBlocks.BURNING_LOG_PILE.get());
    }
}

