/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Consumer;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TFCBlockEntity;
import net.dries007.tfc.util.MetalItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class IngotPileBlockEntity
extends TFCBlockEntity {
    private final List<Entry> entries = new ArrayList<Entry>();

    public IngotPileBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFCBlockEntities.INGOT_PILE.get(), pos, state);
    }

    public void addIngot(ItemStack stack) {
        this.entries.add(new Entry(stack));
        this.markForSync();
    }

    public void removeAllIngots(Consumer<ItemStack> ingotConsumer) {
        for (Entry entry : this.entries) {
            ingotConsumer.accept(entry.stack);
        }
        this.entries.clear();
        this.markForSync();
    }

    public ItemStack removeIngot() {
        if (!this.entries.isEmpty()) {
            Entry entry = this.entries.remove(this.entries.size() - 1);
            this.markForSync();
            return entry.stack;
        }
        return ItemStack.EMPTY;
    }

    public MetalItem getOrCacheMetal(int index) {
        Entry entry;
        if (index >= this.entries.size()) {
            return MetalItem.unknown();
        }
        try {
            entry = this.entries.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            return MetalItem.unknown();
        }
        if (entry.metal == null) {
            entry.metal = MetalItem.getOrUnknown(entry.stack);
        }
        return entry.metal;
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        ListTag stacks = new ListTag();
        for (Entry entry : this.entries) {
            stacks.add((Object)entry.stack.save(provider));
        }
        tag.put("stacks", (Tag)stacks);
        super.saveAdditional(tag, provider);
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        this.entries.clear();
        ListTag list = tag.getList("stacks", 10);
        for (int i = 0; i < list.size(); ++i) {
            this.entries.add(new Entry(ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)list.getCompound(i))));
        }
        super.loadAdditional(tag, provider);
    }

    public void fillTooltip(Consumer<Component> tooltip) {
        class Counter {
            final ItemStack stack;
            int count = 0;

            Counter(IngotPileBlockEntity this$0, ItemStack stack) {
                this.stack = stack;
            }
        }
        LinkedHashMap<MetalItem, Counter> counts = new LinkedHashMap<MetalItem, Counter>();
        for (Entry entry : this.entries) {
            if (entry.metal == null) continue;
            counts.compute(entry.metal, (key, old) -> {
                if (old == null) {
                    old = new Counter(this, entry.stack);
                }
                ++old.count;
                return old;
            });
        }
        for (Counter value : counts.values()) {
            tooltip.accept((Component)Component.literal((String)(value.count + "x ")).append(value.stack.getHoverName()));
        }
    }

    public ItemStack getPickedItemStack() {
        return this.entries.isEmpty() ? ItemStack.EMPTY : this.entries.get((int)0).stack.copy();
    }

    static class Entry {
        final ItemStack stack;
        @Nullable
        MetalItem metal;

        Entry(ItemStack stack) {
            this.stack = stack;
        }
    }
}

