/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.devices.LogPileBlock;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;

public class LogPileBlockEntity
extends InventoryBlockEntity<ItemStackHandler> {
    public static final int SLOTS = 16;
    private boolean needsLogDispersion = true;

    public LogPileBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFCBlockEntities.LOG_PILE.get(), pos, state, LogPileBlockEntity.defaultInventory(16));
    }

    @Override
    public void setAndUpdateSlots(int slot) {
        super.setAndUpdateSlots(slot);
        if (this.level != null && !this.level.isClientSide()) {
            this.suckLogsFromAbove();
            if (this.isEmpty()) {
                this.level.setBlockAndUpdate(this.worldPosition, Blocks.AIR.defaultBlockState());
            } else if (!this.isEmpty()) {
                this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)LogPileBlock.COUNT, (Comparable)Integer.valueOf(this.logCount())));
            }
        }
    }

    public boolean isEmpty() {
        for (ItemStack stack : Helpers.iterate((IItemHandler)this.inventory)) {
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public int logCount() {
        int count = 0;
        for (ItemStack stack : Helpers.iterate((IItemHandler)this.inventory)) {
            if (stack.isEmpty()) continue;
            ++count;
        }
        return count;
    }

    private void suckLogsFromAbove() {
        LogPileBlockEntity logPileAbove;
        BlockEntity blockEntity;
        if (this.level != null && !this.level.isClientSide() && (blockEntity = this.level.getBlockEntity(this.getBlockPos().above())) instanceof LogPileBlockEntity && !(logPileAbove = (LogPileBlockEntity)blockEntity).isEmpty()) {
            for (int i = 0; i < 16; ++i) {
                ItemStack stack = ((ItemStackHandler)logPileAbove.inventory).getStackInSlot(i);
                if (stack.isEmpty()) continue;
                for (int j = 0; j < 16; ++j) {
                    ItemStack moveToStack = ((ItemStackHandler)this.inventory).getStackInSlot(j);
                    if (!moveToStack.isEmpty()) continue;
                    ((ItemStackHandler)this.inventory).setStackInSlot(j, stack.split(1));
                }
            }
            logPileAbove.setAndUpdateSlots(-1);
        }
    }

    private void disperseLogsToNewSlots() {
        for (int i = 0; i < 16; ++i) {
            ItemStack stack = ((ItemStackHandler)this.inventory).getStackInSlot(i);
            while (stack.getCount() > this.getSlotStackLimit(i)) {
                for (int j = 0; j < 16; ++j) {
                    ItemStack moveToStack = ((ItemStackHandler)this.inventory).getStackInSlot(j);
                    if (!moveToStack.isEmpty()) continue;
                    ((ItemStackHandler)this.inventory).setStackInSlot(j, stack.split(1));
                }
            }
        }
    }

    @Override
    protected void onLoadAdditional() {
        if (this.needsLogDispersion) {
            this.disperseLogsToNewSlots();
            this.needsLogDispersion = false;
        }
    }

    @Override
    public int getSlotStackLimit(int slot) {
        return 1;
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        return Helpers.isItem(stack.getItem(), TFCTags.Items.LOG_PILE_LOGS);
    }
}

