/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TFCBlockEntity;
import net.dries007.tfc.common.blocks.GroundcoverBlockType;
import net.dries007.tfc.common.blocks.ISpecialPile;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class PileBlockEntity
extends TFCBlockEntity {
    private BlockState internalState = Blocks.AIR.defaultBlockState();
    @Nullable
    private BlockState aboveState = null;

    public PileBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFCBlockEntities.PILE.get(), pos, state);
    }

    public void setHiddenStates(BlockState internalState, @Nullable BlockState aboveState, boolean byPlayer) {
        ISpecialPile special;
        Block block;
        if (Helpers.isBlock(internalState, TFCTags.Blocks.CONVERTS_TO_HUMUS) && !byPlayer) {
            this.internalState = ((Block)TFCBlocks.GROUNDCOVER.get((Object)GroundcoverBlockType.HUMUS).get()).defaultBlockState();
        } else {
            block = internalState.getBlock();
            if (block instanceof ISpecialPile) {
                special = (ISpecialPile)block;
                this.internalState = special.getHiddenState(internalState, byPlayer);
            } else {
                this.internalState = internalState;
            }
        }
        if (aboveState != null && (block = aboveState.getBlock()) instanceof ISpecialPile) {
            special = (ISpecialPile)block;
            this.aboveState = special.getHiddenStateAbove(aboveState, byPlayer);
        } else {
            this.aboveState = aboveState;
        }
    }

    public BlockState getInternalState() {
        return this.internalState;
    }

    @Nullable
    public BlockState getAboveState() {
        return this.aboveState;
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        this.internalState = NbtUtils.readBlockState((HolderGetter)provider.lookupOrThrow(Registries.BLOCK), (CompoundTag)tag.getCompound("internalState"));
        this.aboveState = tag.contains("aboveState", 10) ? NbtUtils.readBlockState((HolderGetter)provider.lookupOrThrow(Registries.BLOCK), (CompoundTag)tag.getCompound("aboveState")) : null;
        super.loadAdditional(tag, provider);
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        tag.put("internalState", (Tag)NbtUtils.writeBlockState((BlockState)this.internalState));
        if (this.aboveState != null) {
            tag.put("aboveState", (Tag)NbtUtils.writeBlockState((BlockState)this.aboveState));
        }
        super.saveAdditional(tag, provider);
    }
}

