/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import java.util.List;
import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.devices.PitKilnBlock;
import net.dries007.tfc.common.blocks.devices.PlacedItemBlock;
import net.dries007.tfc.common.capabilities.InventoryItemHandler;
import net.dries007.tfc.common.component.size.ItemSizeManager;
import net.dries007.tfc.common.component.size.Size;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;

public class PlacedItemBlockEntity
extends InventoryBlockEntity<ItemStackHandler> {
    public static final int SLOT_LARGE_ITEM = 0;
    boolean isHoldingLargeItem = false;
    private final float[] rotations = new float[]{0.0f, 0.0f, 0.0f, 0.0f};

    public static void convertPlacedItemToPitKiln(Level level, BlockPos pos, ItemStack strawStack) {
        level.getBlockEntity(pos, (BlockEntityType)TFCBlockEntities.PLACED_ITEM.get()).ifPresent(placedItem -> {
            List<ItemStack> items = Helpers.copyToAndClear(placedItem.inventory);
            int stage = PitKilnBlock.strawValue(strawStack.getItem()) - 1;
            level.setBlockAndUpdate(pos, (BlockState)((Block)TFCBlocks.PIT_KILN.get()).defaultBlockState().setValue((Property)PitKilnBlock.STAGE, (Comparable)Integer.valueOf(stage)));
            placedItem.setRemoved();
            level.playSound(null, pos, SoundEvents.GRASS_PLACE, SoundSource.BLOCKS, 0.5f, 1.0f);
            level.getBlockEntity(pos, (BlockEntityType)TFCBlockEntities.PIT_KILN.get()).ifPresent(pitKiln -> {
                Helpers.copyFrom(items, pitKiln.inventory);
                pitKiln.isHoldingLargeItem = placedItem.isHoldingLargeItem;
                pitKiln.addStraw(strawStack, stage);
            });
        });
    }

    public static int getSlotSelected(BlockHitResult rayTrace) {
        Vec3 location = rayTrace.getLocation();
        boolean x = (double)Math.round(location.x) < location.x;
        boolean z = (double)Math.round(location.z) < location.z;
        return (x ? 1 : 0) + (z ? 2 : 0);
    }

    public PlacedItemBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)TFCBlockEntities.PLACED_ITEM.get(), pos, state);
    }

    protected PlacedItemBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state, self -> new InventoryItemHandler(self, 4));
    }

    public boolean onRightClick(Player player, ItemStack stack, BlockHitResult rayTrace) {
        Vec3 location = rayTrace.getLocation();
        return this.onRightClick(player, stack, (double)Math.round(location.x) < location.x, (double)Math.round(location.z) < location.z);
    }

    public boolean insertItem(Player player, ItemStack stack, BlockHitResult rayTrace) {
        return this.insertItem(player, stack, PlacedItemBlockEntity.getSlotSelected(rayTrace));
    }

    public boolean onRightClick(Player player, ItemStack stack, boolean x, boolean z) {
        int slot = (x ? 1 : 0) + (z ? 2 : 0);
        if (player.getItemInHand(InteractionHand.MAIN_HAND).isEmpty() || player.isShiftKeyDown()) {
            ItemStack current = this.isHoldingLargeItem ? ((ItemStackHandler)this.inventory).getStackInSlot(0) : ((ItemStackHandler)this.inventory).getStackInSlot(slot);
            if (!current.isEmpty()) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)current.copy());
                ((ItemStackHandler)this.inventory).setStackInSlot(this.isHoldingLargeItem ? 0 : slot, ItemStack.EMPTY);
                this.isHoldingLargeItem = false;
                this.updateBlock();
                return true;
            }
        } else if (!stack.isEmpty()) {
            return this.insertItem(player, stack, slot);
        }
        return false;
    }

    public boolean insertItem(Player player, ItemStack stack, int slot) {
        Size size = ItemSizeManager.get(stack).getSize(stack);
        if (size.isEqualOrSmallerThan(TFCConfig.SERVER.maxPlacedItemSize.get()) && !this.isHoldingLargeItem) {
            if (((ItemStackHandler)this.inventory).getStackInSlot(slot).isEmpty()) {
                ItemStack input;
                if (player.isCreative()) {
                    input = stack.copy();
                    input.setCount(1);
                } else {
                    input = stack.split(1);
                }
                ((ItemStackHandler)this.inventory).setStackInSlot(slot, input);
                this.rotations[slot] = (float)Math.round(player.getYRot() / 15.0f) * 15.0f;
                this.updateBlock();
                return true;
            }
        } else if (!size.isEqualOrSmallerThan(TFCConfig.SERVER.maxPlacedItemSize.get()) && size.isEqualOrSmallerThan(TFCConfig.SERVER.maxPlacedLargeItemSize.get()) && PlacedItemBlock.isFullContents(this.getBlockState()) && this.isEmpty()) {
            ItemStack input;
            if (player.isCreative()) {
                input = stack.copy();
                input.setCount(1);
            } else {
                input = stack.split(1);
            }
            ((ItemStackHandler)this.inventory).setStackInSlot(0, input);
            this.isHoldingLargeItem = true;
            this.rotations[0] = (float)Math.round(player.getYRot() / 15.0f) * 15.0f;
            this.updateBlock();
            return true;
        }
        return false;
    }

    public void ejectInventoryIfNeeded(BlockState newState) {
        assert (this.level != null);
        if (this.getBlockState().getBlock() != newState.getBlock()) {
            super.ejectInventory();
            return;
        }
        for (int slot = 0; slot < ((ItemStackHandler)this.getInventory()).getSlots(); ++slot) {
            ItemStack stack;
            if (((Boolean)newState.getValue((Property)PlacedItemBlock.ITEM_PROPERTIES[slot])).booleanValue() || (stack = Helpers.removeStack((IItemHandler)this.inventory, slot)).isEmpty()) continue;
            Helpers.spawnItem(this.level, this.worldPosition, stack);
        }
    }

    public float getRotations(int slot) {
        return this.rotations[slot];
    }

    public ItemStack getCloneItemStack(BlockState state, BlockHitResult hit) {
        return ((ItemStackHandler)this.inventory).getStackInSlot(PlacedItemBlockEntity.getSlotSelected(hit)).copy();
    }

    public boolean holdingLargeItem() {
        return this.isHoldingLargeItem;
    }

    @Override
    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        this.isHoldingLargeItem = nbt.getBoolean("isHoldingLargeItem");
        this.rotations[0] = nbt.getFloat("rotation1");
        this.rotations[1] = nbt.getFloat("rotation2");
        this.rotations[2] = nbt.getFloat("rotation3");
        this.rotations[3] = nbt.getFloat("rotation4");
        super.loadAdditional(nbt, provider);
    }

    @Override
    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        nbt.putBoolean("isHoldingLargeItem", this.isHoldingLargeItem);
        nbt.putFloat("rotation1", this.rotations[0]);
        nbt.putFloat("rotation2", this.rotations[1]);
        nbt.putFloat("rotation3", this.rotations[2]);
        nbt.putFloat("rotation4", this.rotations[3]);
        super.saveAdditional(nbt, provider);
    }

    protected void updateBlock() {
        if (this.isEmpty() && this.level != null && this.getType() == TFCBlockEntities.PLACED_ITEM.get()) {
            this.level.setBlockAndUpdate(this.worldPosition, Blocks.AIR.defaultBlockState());
        } else {
            this.markForSync();
        }
    }

    protected boolean isEmpty() {
        if (this.isHoldingLargeItem && ((ItemStackHandler)this.inventory).getStackInSlot(0).isEmpty()) {
            return true;
        }
        for (int i = 0; i < 4; ++i) {
            if (((ItemStackHandler)this.inventory).getStackInSlot(i).isEmpty()) continue;
            return false;
        }
        return true;
    }
}

