/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TickableInventoryBlockEntity;
import net.dries007.tfc.common.blocks.devices.SluiceBlock;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.data.Deposit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class SluiceBlockEntity
extends TickableInventoryBlockEntity<ItemStackHandler> {
    public static final int MAX_SOIL = 32;
    private int ticksRemaining = 0;

    public static void serverTick(Level level, BlockPos pos, BlockState state, SluiceBlockEntity sluice) {
        BlockPos fluidOutputPos;
        Fluid fluid;
        BlockPos outputPos;
        Fluid fluid2;
        boolean activeTick;
        if (!((Boolean)state.getValue((Property)SluiceBlock.UPPER)).booleanValue()) {
            return;
        }
        State sluiceState = sluice.getRepresentativeState();
        if (sluiceState == State.NONE) {
            return;
        }
        sluice.checkForLastTickSync();
        boolean bl = activeTick = level.getGameTime() % 20L == 0L;
        if (sluiceState == State.BOTH && activeTick) {
            Helpers.gatherAndConsumeItems(level, new AABB((double)-0.2f, 0.5, (double)-0.2f, (double)1.2f, 1.25, (double)1.2f).move(pos), (IItemHandler)sluice.inventory, 0, 31, 1);
        }
        if (sluiceState == State.BOTH && --sluice.ticksRemaining <= 0) {
            boolean itemUsed = false;
            for (ItemStack stack : Helpers.iterate((IItemHandler)sluice.inventory)) {
                if (stack.isEmpty()) continue;
                @Nullable Deposit deposit = Deposit.get(stack);
                if (deposit != null && level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    LootParams.Builder builder = new LootParams.Builder(serverLevel).withOptionalParameter(LootContextParams.ORIGIN, (Object)new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()));
                    LootTable table = serverLevel.getServer().reloadableRegistries().getLootTable(deposit.lootTable());
                    ObjectArrayList items = table.getRandomItems(builder.create(LootContextParamSets.EMPTY));
                    Direction dir = (Direction)state.getValue((Property)SluiceBlock.FACING);
                    items.forEach(item -> Helpers.spawnItem(level, sluice.getWaterOutputPos(), item, 1.125, (double)dir.getStepX() * 0.12 * (double)level.random.nextFloat(), 0.0, (double)dir.getStepZ() * 0.12 * (double)level.random.nextFloat()));
                }
                stack.setCount(0);
                itemUsed = true;
                break;
            }
            if (itemUsed) {
                Helpers.playSound(level, sluice.getBlockPos(), SoundEvents.ITEM_PICKUP);
            }
            sluice.ticksRemaining = TFCConfig.SERVER.sluiceTicks.get();
            sluice.markForSync();
        }
        if (!activeTick) {
            return;
        }
        if (sluiceState == State.INPUT_ONLY && !(fluid2 = level.getFluidState(sluice.getWaterInputPos()).getType()).isSame(Fluids.EMPTY) && sluice.isFluidValid(fluid2) && level.getBlockState(outputPos = sluice.getWaterOutputPos()).canBeReplaced()) {
            FluidHelpers.setSourceBlock(level, outputPos, fluid2);
        }
        if (sluiceState == State.OUTPUT_ONLY && sluice.isFluidValid(fluid = level.getFluidState(fluidOutputPos = sluice.getWaterOutputPos()).getType())) {
            BlockState outputState = level.getBlockState(fluidOutputPos);
            BlockState resultState = FluidHelpers.emptyFluidFrom(outputState);
            level.setBlockAndUpdate(fluidOutputPos, resultState);
            if (!resultState.isAir()) {
                level.scheduleTick(fluidOutputPos, resultState.getBlock(), 1);
            }
        }
    }

    public SluiceBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFCBlockEntities.SLUICE.get(), pos, state, SluiceBlockEntity.defaultInventory(32));
    }

    @Override
    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        this.ticksRemaining = nbt.getInt("ticksRemaining");
        super.loadAdditional(nbt, provider);
    }

    @Override
    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        nbt.putInt("ticksRemaining", this.ticksRemaining);
        super.saveAdditional(nbt, provider);
    }

    @Override
    public int getSlotStackLimit(int slot) {
        return 1;
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        return Deposit.get(stack) != null;
    }

    @Override
    public void setAndUpdateSlots(int slot) {
        super.setAndUpdateSlots(slot);
        this.markForSync();
    }

    public Direction getFacing() {
        return (Direction)this.getBlockState().getValue((Property)SluiceBlock.FACING);
    }

    public BlockPos getWaterOutputPos() {
        return SluiceBlock.getFluidOutputPos(this.getBlockState(), this.getBlockPos());
    }

    public BlockPos getWaterInputPos() {
        return this.getBlockPos().above().relative(this.getFacing().getOpposite());
    }

    @Nullable
    public Fluid getFlow() {
        assert (this.level != null);
        FluidState inputState = this.level.getFluidState(this.getWaterInputPos());
        Fluid input = inputState.getType();
        Fluid output = this.level.getFluidState(this.getWaterOutputPos()).getType();
        if (inputState.hasProperty((Property)FlowingFluid.LEVEL) && (Integer)inputState.getValue((Property)FlowingFluid.LEVEL) == 1 && this.isFluidValid(input) && output.isSame(input)) {
            return input;
        }
        return null;
    }

    private State getRepresentativeState() {
        assert (this.level != null);
        FluidState inputState = this.level.getFluidState(this.getWaterInputPos());
        Fluid input = inputState.getType();
        Fluid output = this.level.getFluidState(this.getWaterOutputPos()).getType();
        boolean isInputValid = this.isFluidValid(input) && inputState.hasProperty((Property)FlowingFluid.LEVEL) && (Integer)inputState.getValue((Property)FlowingFluid.LEVEL) == 1;
        boolean isOutputValid = this.isFluidValid(output);
        return isInputValid ? (isOutputValid && output.isSame(input) ? State.BOTH : State.INPUT_ONLY) : (isOutputValid ? State.OUTPUT_ONLY : State.NONE);
    }

    public boolean isFluidValid(Fluid fluid) {
        return Helpers.isFluid(fluid, TFCTags.Fluids.USABLE_IN_SLUICE);
    }

    static enum State {
        NONE,
        INPUT_ONLY,
        OUTPUT_ONLY,
        BOTH;

    }
}

