/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class TFCBlockEntity
extends BlockEntity {
    protected TFCBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public final ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public final void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet, HolderLookup.Provider provider) {
        super.onDataPacket(net, packet, provider);
    }

    public final CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveCustomOnly(provider);
    }

    public final void handleUpdateTag(CompoundTag tag, HolderLookup.Provider provider) {
        super.handleUpdateTag(tag, provider);
    }

    public final void setRemoved() {
        super.setRemoved();
        this.onUnloadAdditional();
    }

    public final void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.onUnloadAdditional();
    }

    public final void onLoad() {
        this.requestModelDataUpdate();
        this.onLoadAdditional();
    }

    protected void onLoadAdditional() {
    }

    protected void onUnloadAdditional() {
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
    }

    public void markForSync() {
        this.sendVanillaUpdatePacket();
        this.setChanged();
    }

    public final void markDirty() {
        if (this.level != null) {
            this.level.blockEntityChanged(this.worldPosition);
        }
    }

    public final void sendVanillaUpdatePacket() {
        Level level;
        ClientboundBlockEntityDataPacket packet = this.getUpdatePacket();
        BlockPos pos = this.getBlockPos();
        if (packet != null && (level = this.level) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.getChunkSource().chunkMap.getPlayers(new ChunkPos(pos), false).forEach(e -> e.connection.send((Packet)packet));
        }
    }
}

