/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.capabilities.InventoryWrapper;
import net.dries007.tfc.common.component.size.ItemSizeManager;
import net.dries007.tfc.common.container.ISlotCallback;
import net.dries007.tfc.common.container.PestContainer;
import net.dries007.tfc.common.container.RestrictedChestContainer;
import net.dries007.tfc.common.container.TFCContainerTypes;
import net.dries007.tfc.config.TFCConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class TFCChestBlockEntity
extends ChestBlockEntity
implements PestContainer,
ISlotCallback {
    @Nullable
    private IItemHandler inventoryHandler = null;

    public static boolean isValid(ItemStack stack) {
        return ItemSizeManager.get(stack).getSize(stack).isEqualOrSmallerThan(TFCConfig.SERVER.chestMaximumItemSize.get());
    }

    public TFCChestBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public TFCChestBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)TFCBlockEntities.CHEST.get(), pos, state);
    }

    public int getContainerSize() {
        return 18;
    }

    protected AbstractContainerMenu createMenu(int id, Inventory inventory) {
        return new RestrictedChestContainer((MenuType)TFCContainerTypes.CHEST_9x2.get(), id, inventory, (Container)this, 2);
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        return TFCChestBlockEntity.isValid(stack);
    }

    public void setBlockState(BlockState state) {
        super.setBlockState(state);
        this.invalidateInventoryHandler();
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        return TFCChestBlockEntity.isValid(stack);
    }

    private void invalidateInventoryHandler() {
        if (this.inventoryHandler != null) {
            this.inventoryHandler = null;
        }
    }

    @Nullable
    public IItemHandler getInventoryHandler(@Nullable Direction direction) {
        if (this.inventoryHandler != null) {
            return this.inventoryHandler;
        }
        assert (this.level != null);
        BlockState state = this.getBlockState();
        Block block = state.getBlock();
        if (!(block instanceof ChestBlock)) {
            return null;
        }
        ChestBlock chest = (ChestBlock)block;
        @Nullable Object chestContainer = ChestBlock.getContainer((ChestBlock)chest, (BlockState)state, (Level)this.level, (BlockPos)this.getBlockPos(), (boolean)true);
        if (chestContainer == null) {
            chestContainer = this;
        }
        this.inventoryHandler = new InventoryWrapper((Container)chestContainer, this);
        return this.inventoryHandler;
    }
}

