/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import net.dries007.tfc.common.blockentities.IHeatable;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TickableBlockEntity;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.component.heat.Heat;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.climate.Climate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class ThermometerBlockEntity
extends TickableBlockEntity {
    public ThermometerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public ThermometerBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)TFCBlockEntities.THERMOMETER.get(), pos, state);
    }

    public void needsInstantUpdate() {
        assert (this.level != null);
        ThermometerBlockEntity.updatePower(this.level, this.worldPosition, this.getBlockState());
    }

    public static void updatePower(Level level, BlockPos pos, BlockState state) {
        if (Helpers.isBlock(state, (Block)TFCBlocks.THERMOMETER.get())) {
            int newPower;
            if (((Boolean)state.getValue((Property)TFCBlockStateProperties.THERMOMETER_ATTACHED)).booleanValue()) {
                Direction direction = ((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getOpposite();
                float temperature = 0.0f;
                BlockEntity blockEntity = level.getBlockEntity(pos.relative(direction));
                if (blockEntity instanceof IHeatable) {
                    IHeatable heatable = (IHeatable)blockEntity;
                    temperature = heatable.getTemperature();
                }
                newPower = (int)Math.floor(Mth.clampedMap((float)temperature, (float)0.0f, (float)Heat.maxVisibleTemperature(), (float)0.0f, (float)15.0f));
            } else {
                newPower = (int)Math.floor(Mth.clampedMap((float)Climate.get(level).getTemperature((LevelReader)level, pos), (float)-40.0f, (float)40.0f, (float)0.0f, (float)15.0f));
            }
            if (newPower != (Integer)state.getValue((Property)BlockStateProperties.POWER)) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)BlockStateProperties.POWER, (Comparable)Integer.valueOf(newPower)));
                level.updateNeighborsAt(pos.relative(((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getOpposite()), state.getBlock());
            }
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, ThermometerBlockEntity thermometer) {
        if (level.getGameTime() % 40L == 0L) {
            ThermometerBlockEntity.updatePower(level, pos, state);
        }
    }
}

