/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks;

import net.dries007.tfc.common.blockentities.FireboxBlockEntity;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.dries007.tfc.common.blocks.devices.IBellowsConsumer;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;

public class FireboxBlock
extends DeviceBlock
implements IBellowsConsumer {
    public static final BooleanProperty LIT = BlockStateProperties.LIT;

    public FireboxBlock(ExtendedProperties properties) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.DROP);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FireboxBlockEntity) {
            FireboxBlockEntity firebox = (FireboxBlockEntity)blockEntity;
            ItemStackHandler inv = (ItemStackHandler)firebox.getInventory();
            if (firebox.isItemValid(0, stack)) {
                ItemStack leftover = Helpers.insertAllSlots((IItemHandler)inv, stack.split(1));
                if (!leftover.isEmpty()) {
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)leftover);
                    return ItemInteractionResult.FAIL;
                }
                return ItemInteractionResult.SUCCESS;
            }
            if (stack.isEmpty() && player.isShiftKeyDown() && !inv.getStackInSlot(0).isEmpty()) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)inv.getStackInSlot(0));
                return ItemInteractionResult.SUCCESS;
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.openMenu((MenuProvider)firebox, pos);
            }
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void stepOn(Level level, BlockPos pos, BlockState state, Entity entity) {
        if (entity instanceof LivingEntity && ((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            entity.hurt(entity.damageSources().hotFloor(), 1.0f);
        }
        super.stepOn(level, pos, state, entity);
    }

    protected boolean hasAnalogOutputSignal(BlockState state) {
        return TFCConfig.SERVER.fireboxEnableAutomation.get();
    }

    protected int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        FireboxBlockEntity firebox;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FireboxBlockEntity && !((ItemStackHandler)(firebox = (FireboxBlockEntity)blockEntity).getInventory()).getStackInSlot(0).isEmpty()) {
            int maxSlot = 16;
            for (int i = 0; i < maxSlot; ++i) {
                if (!((ItemStackHandler)firebox.getInventory()).getStackInSlot(i).isEmpty()) continue;
                return Mth.clamp((int)(i * 15 / maxSlot), (int)1, (int)15);
            }
            return 15;
        }
        return 0;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)LIT)).booleanValue() && random.nextInt(7) == 0) {
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                ParticleUtils.spawnParticleOnFace((Level)level, (BlockPos)pos, (Direction)dir, (ParticleOptions)ParticleTypes.FLAME, (Vec3)Helpers.getRandomSpeedRanges(random).scale(0.1), (double)0.55);
            }
            if (random.nextInt(14) == 0) {
                level.playLocalSound(pos, SoundEvents.BLASTFURNACE_FIRE_CRACKLE, SoundSource.BLOCKS, 0.5f + random.nextFloat(), random.nextFloat() * 0.7f + 0.6f, false);
            }
        }
    }

    @Override
    public void intakeAir(Level level, BlockPos pos, BlockState state, int amount) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FireboxBlockEntity) {
            FireboxBlockEntity firebox = (FireboxBlockEntity)blockEntity;
            firebox.intakeAir(amount);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{LIT}));
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }
}

