/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks;

import java.util.function.Function;
import net.dries007.tfc.common.blocks.GroundcoverBlock;
import net.dries007.tfc.common.items.Powder;
import net.dries007.tfc.common.items.TFCItems;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public enum GroundcoverBlockType {
    BONE(GroundcoverBlock.MEDIUM, (ItemLike)Items.BONE),
    CLAM(GroundcoverBlock.SMALL),
    DRIFTWOOD(GroundcoverBlock.FLAT),
    FEATHER(GroundcoverBlock.FLAT, (ItemLike)Items.FEATHER),
    FLINT(GroundcoverBlock.SMALL, (ItemLike)Items.FLINT),
    GUANO(GroundcoverBlock.PIXEL_HIGH),
    HUMUS(GroundcoverBlock.PIXEL_HIGH),
    MOLLUSK(GroundcoverBlock.SMALL),
    MUSSEL(GroundcoverBlock.SMALL),
    PINECONE(GroundcoverBlock.SMALL),
    PUMICE(GroundcoverBlock.SMALL),
    ROTTEN_FLESH(GroundcoverBlock.FLAT, (ItemLike)Items.ROTTEN_FLESH),
    SALT_LICK(GroundcoverBlock.PIXEL_HIGH, TFCItems.POWDERS.get((Object)((Object)Powder.SALT))),
    SEAWEED(GroundcoverBlock.FLAT),
    SEA_URCHIN(GroundcoverBlock.MEDIUM),
    STICK(GroundcoverBlock.FLAT, (ItemLike)Items.STICK);

    private final VoxelShape shape;
    @Nullable
    private final ItemLike vanillaItem;

    private GroundcoverBlockType(VoxelShape shape) {
        this(shape, null);
    }

    private GroundcoverBlockType(VoxelShape shape, ItemLike vanillaItem) {
        this.shape = shape;
        this.vanillaItem = vanillaItem;
    }

    public VoxelShape getShape() {
        return this.shape;
    }

    @Nullable
    public Function<Block, BlockItem> createBlockItem() {
        return this.vanillaItem == null ? block -> new BlockItem(block, new Item.Properties()) : null;
    }

    @Nullable
    public ItemLike getVanillaItem() {
        return this.vanillaItem;
    }
}

