/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks;

import java.util.function.Supplier;
import net.dries007.tfc.client.particle.TFCParticles;
import net.dries007.tfc.config.TFCConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;

public class HotWaterBlock
extends LiquidBlock {
    public HotWaterBlock(Supplier<? extends FlowingFluid> supplier, BlockBehaviour.Properties properties) {
        super(supplier.get(), properties);
    }

    public void animateTick(BlockState stateIn, Level level, BlockPos pos, RandomSource random) {
        double x = (float)pos.getX() + random.nextFloat();
        double y = pos.getY();
        double z = (float)pos.getZ() + random.nextFloat();
        if (level.isEmptyBlock(pos.above())) {
            level.addParticle((ParticleOptions)TFCParticles.STEAM.get(), x, y + 1.0, z, 0.0, 0.0, 0.0);
        }
        if (random.nextInt(3) == 0) {
            level.addParticle((ParticleOptions)TFCParticles.BUBBLE.get(), x, y + (double)random.nextFloat(), z, 0.0, 0.04, 0.0);
        }
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        LivingEntity living;
        if (level.random.nextInt(10) == 0 && entity instanceof LivingEntity && (living = (LivingEntity)entity).getHealth() < living.getMaxHealth()) {
            living.heal(TFCConfig.SERVER.hotWaterHealAmount.get().floatValue());
        }
    }
}

