/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks;

import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.EntityBlockExtension;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.IForgeBlockExtension;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.util.EnvironmentHelpers;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IceBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public class IcePileBlock
extends IceBlock
implements IForgeBlockExtension,
EntityBlockExtension {
    private final ExtendedProperties properties;

    public static void placeIcePileOrIce(LevelAccessor level, BlockPos groundPos, BlockState groundState, boolean skipEdgeCheck) {
        FluidState fluid = groundState.getFluidState();
        boolean icePileAtGround = Helpers.isBlock(groundState.getBlock(), TFCTags.Blocks.CAN_BE_ICE_PILED);
        if (fluid.getType() == Fluids.WATER && (icePileAtGround || groundState.getBlock() == Blocks.WATER) && (skipEdgeCheck || EnvironmentHelpers.isAdjacentToNotWater(level, groundPos))) {
            BlockPos surfacePos = groundPos.above();
            BlockState surfaceState = level.getBlockState(surfacePos);
            boolean icePileAtSurface = Helpers.isBlock(surfaceState.getBlock(), TFCTags.Blocks.CAN_BE_ICE_PILED);
            if (icePileAtGround || icePileAtSurface) {
                BlockState savedGroundState = icePileAtGround ? groundState : Blocks.WATER.defaultBlockState();
                BlockState savedSurfaceState = icePileAtSurface ? surfaceState : null;
                level.setBlock(groundPos, ((IcePileBlock)TFCBlocks.ICE_PILE.get()).defaultBlockState(), 18);
                level.getBlockEntity(groundPos, (BlockEntityType)TFCBlockEntities.PILE.get()).ifPresent(pile -> pile.setHiddenStates(savedGroundState, savedSurfaceState, false));
                if (icePileAtSurface) {
                    Helpers.removeBlock(level, surfacePos, 18);
                }
                level.blockUpdated(groundPos, (Block)TFCBlocks.ICE_PILE.get());
                if (icePileAtSurface) {
                    level.blockUpdated(surfacePos, Blocks.AIR);
                }
            } else {
                level.setBlock(groundPos, Blocks.ICE.defaultBlockState(), 3);
            }
        }
    }

    public static void removeIcePileOrIce(LevelAccessor level, BlockPos pos, BlockState state) {
        boolean ultrawarm = level.dimensionType().ultraWarm();
        BlockState belowState = level.getBlockState(pos.below());
        if (!ultrawarm && (belowState.blocksMotion() || belowState.liquid())) {
            if (state.getBlock() == Blocks.ICE) {
                level.setBlock(pos, Blocks.WATER.defaultBlockState(), 3);
            } else {
                level.getBlockEntity(pos, (BlockEntityType)TFCBlockEntities.PILE.get()).ifPresent(pile -> {
                    if (!level.isClientSide()) {
                        BlockPos above = pos.above();
                        level.setBlock(pos, pile.getInternalState(), 18);
                        if (pile.getAboveState() != null && level.isEmptyBlock(above)) {
                            level.setBlock(above, pile.getAboveState(), 18);
                        }
                        level.blockUpdated(pos, pile.getInternalState().getBlock());
                        level.scheduleTick(pos, (Fluid)Fluids.WATER, 1);
                        if (pile.getAboveState() != null) {
                            level.blockUpdated(above, pile.getAboveState().getBlock());
                        }
                    }
                });
            }
        } else if (state.getBlock() == Blocks.ICE || state.getBlock() == TFCBlocks.ICE_PILE.get()) {
            level.removeBlock(pos, false);
        }
    }

    public IcePileBlock(ExtendedProperties properties) {
        super(properties.properties());
        this.properties = properties;
    }

    @Override
    public ExtendedProperties getExtendedProperties() {
        return this.properties;
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        this.playerWillDestroy(level, pos, state, player);
        IcePileBlock.removeIcePileOrIce((LevelAccessor)level, pos, state);
        return false;
    }

    public boolean skipRendering(BlockState state, BlockState otherState, Direction facing) {
        return Helpers.isBlock(otherState, Blocks.ICE) || super.skipRendering(state, otherState, facing);
    }

    public boolean hidesNeighborFace(BlockGetter level, BlockPos pos, BlockState state, BlockState neighborState, Direction dir) {
        return Helpers.isBlock(neighborState, Blocks.ICE);
    }
}

