/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks;

import java.util.Optional;
import net.dries007.tfc.common.blockentities.LargeVesselBlockEntity;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TooltipBlock;
import net.dries007.tfc.common.blocks.devices.BottomSupportedDeviceBlock;
import net.dries007.tfc.common.blocks.devices.SealableDeviceBlock;
import net.dries007.tfc.common.component.TFCComponents;
import net.dries007.tfc.common.component.item.ItemListComponent;
import net.dries007.tfc.config.TFCConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LargeVesselBlock
extends SealableDeviceBlock {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.HORIZONTAL_AXIS;
    public static final VoxelShape OPENED_SHAPE = LargeVesselBlock.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0);
    public static final VoxelShape CLOSED_SHAPE = Shapes.or((VoxelShape)OPENED_SHAPE, (VoxelShape[])new VoxelShape[]{LargeVesselBlock.box((double)2.5, (double)9.5, (double)2.5, (double)13.5, (double)11.0, (double)13.5), LargeVesselBlock.box((double)7.0, (double)11.0, (double)7.0, (double)9.0, (double)12.0, (double)9.0)});

    public static <T extends LargeVesselBlockEntity> void toggleSeal(Level level, BlockPos pos, BlockState state, BlockEntityType<T> type) {
        level.getBlockEntity(pos, type).ifPresent(vessel -> {
            boolean previousSealed = (Boolean)state.getValue((Property)SEALED);
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)SEALED, (Comparable)Boolean.valueOf(!previousSealed)));
            if (previousSealed) {
                vessel.onUnseal();
            } else {
                vessel.onSeal();
            }
        });
    }

    public LargeVesselBlock(ExtendedProperties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue(AXIS, (Comparable)Direction.Axis.X)).setValue((Property)SEALED, (Comparable)Boolean.valueOf(false))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        return state != null ? (BlockState)state.setValue(AXIS, (Comparable)context.getHorizontalDirection().getAxis()) : null;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)builder.add(new Property[]{AXIS}));
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Boolean)state.getValue((Property)SEALED) != false ? CLOSED_SHAPE : OPENED_SHAPE;
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return this.canSurvive(state, (LevelReader)level, currentPos) ? super.updateShape(state, facing, facingState, level, currentPos, facingPos) : Blocks.AIR.defaultBlockState();
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return BottomSupportedDeviceBlock.canSurvive(level, pos);
    }

    @Override
    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        return TFCConfig.CLIENT.displayItemContentsAsImages.get() != false ? TooltipBlock.buildInventoryTooltip(((ItemListComponent)stack.getOrDefault(TFCComponents.CONTENTS, (Object)ItemListComponent.EMPTY)).contents(), 3, 3) : Optional.empty();
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (player.isShiftKeyDown()) {
            LargeVesselBlock.toggleSeal(level, pos, state, this.getExtendedProperties().blockEntity());
        } else {
            level.getBlockEntity(pos, this.getExtendedProperties().blockEntity()).ifPresent(vessel -> {
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverPlayer.openMenu((MenuProvider)vessel, pos);
                }
            });
        }
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        BlockEntity blockEntity;
        if (TFCConfig.SERVER.largeVesselEnableRedstoneSeal.get().booleanValue() && (blockEntity = level.getBlockEntity(pos)) instanceof LargeVesselBlockEntity) {
            LargeVesselBlockEntity vessel = (LargeVesselBlockEntity)blockEntity;
            this.handleNeighborChanged(state, level, pos, vessel::onSeal, vessel::onUnseal);
        }
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return rot == Rotation.COUNTERCLOCKWISE_90 || rot == Rotation.CLOCKWISE_90 ? (BlockState)state.cycle(AXIS) : state;
    }
}

