/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks;

import java.util.Map;
import java.util.function.Supplier;
import net.dries007.tfc.client.particle.TFCParticles;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.TFCMagmaBlock;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.fluids.TFCFluids;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BubbleColumnBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.common.util.Lazy;
import org.jetbrains.annotations.Nullable;

public class TFCBubbleColumnBlock
extends BubbleColumnBlock {
    private static final Lazy<Map<Fluid, Block>> BUBBLE_FLUIDS = Lazy.of(() -> Map.of(Fluids.WATER.getSource(), (Block)TFCBlocks.FRESHWATER_BUBBLE_COLUMN.get(), TFCFluids.SALT_WATER.getSource(), (Block)TFCBlocks.SALTWATER_BUBBLE_COLUMN.get(), TFCFluids.SPRING_WATER.getSource(), (Block)TFCBlocks.SPRING_WATER_BUBBLE_COLUMN.get()));
    private final Supplier<? extends Fluid> fluid;

    @Nullable
    public static Block columnOf(Fluid fluid) {
        return (Block)((Map)BUBBLE_FLUIDS.get()).get(fluid);
    }

    public static boolean isDownBubbles(LevelAccessor level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        if (state.getBlock() instanceof TFCBubbleColumnBlock) {
            return (Boolean)state.getValue((Property)DRAG_DOWN);
        }
        return state.getBlock() instanceof TFCMagmaBlock;
    }

    public static void updateColumnForFluid(LevelAccessor level, BlockPos pos) {
        BlockState startState = level.getBlockState(pos);
        if (!(startState.getBlock() instanceof TFCMagmaBlock)) {
            return;
        }
        BlockPos.MutableBlockPos cursor = pos.above().mutable();
        Fluid startingFluid = level.getFluidState((BlockPos)cursor).getType();
        Block columnBlock = TFCBubbleColumnBlock.columnOf(startingFluid);
        if (columnBlock == null) {
            return;
        }
        BlockState newColumn = (BlockState)columnBlock.defaultBlockState().setValue((Property)BubbleColumnBlock.DRAG_DOWN, (Comparable)Boolean.valueOf(true));
        while (cursor.getY() >= level.getMinBuildHeight() && cursor.getY() < level.getMaxBuildHeight()) {
            BlockState state = level.getBlockState((BlockPos)cursor);
            if (!TFCBubbleColumnBlock.canExistIn(state) || state.getBlock() instanceof TFCMagmaBlock) {
                if (!(state.getBlock() instanceof TFCBubbleColumnBlock)) break;
                level.setBlock((BlockPos)cursor, state.getFluidState().createLegacyBlock(), 3);
                break;
            }
            if (!Helpers.isBlock(state, newColumn.getBlock())) {
                level.setBlock((BlockPos)cursor, newColumn, 3);
            }
            cursor.move(Direction.UP);
        }
    }

    public static boolean canExistIn(BlockState state) {
        if (state.getBlock() instanceof TFCBubbleColumnBlock) {
            return true;
        }
        if (FluidHelpers.isAirOrEmptyFluid(state) && !state.isAir()) {
            return TFCBubbleColumnBlock.columnOf(state.getFluidState().getType()) != null;
        }
        return false;
    }

    public TFCBubbleColumnBlock(BlockBehaviour.Properties properties, Supplier<? extends Fluid> fluid) {
        super(properties);
        this.fluid = fluid;
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (!Helpers.isEntity(entity, TFCTags.Entities.BUBBLE_COLUMN_IMMUNE)) {
            super.entityInside(state, level, pos, entity);
        }
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        TFCBubbleColumnBlock.updateColumnForFluid((LevelAccessor)level, pos);
    }

    public FluidState getFluidState(BlockState state) {
        return this.fluid.get().defaultFluidState();
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        double x = pos.getX();
        double y = pos.getY();
        double z = pos.getZ();
        if (level.isEmptyBlock(pos.above()) && this == TFCBubbleColumnBlock.columnOf((Fluid)TFCFluids.SPRING_WATER.getSource())) {
            level.addParticle((ParticleOptions)TFCParticles.STEAM.get(), x, y + 1.0, z, 0.0, 0.0, 0.0);
        }
        if (TFCBubbleColumnBlock.isDownBubbles((LevelAccessor)level, pos)) {
            level.addParticle((ParticleOptions)TFCParticles.BUBBLE_COLUMN_DOWN.get(), x + 0.5, y + 0.8, z, 0.0, 0.0, 0.0);
        } else {
            level.addAlwaysVisibleParticle((ParticleOptions)TFCParticles.BUBBLE_COLUMN_UP.get(), x + 0.5, y, z + 0.5, 0.0, 0.04, 0.0);
            level.addAlwaysVisibleParticle((ParticleOptions)TFCParticles.BUBBLE_COLUMN_UP.get(), x + (double)random.nextFloat(), y + (double)random.nextFloat(), z + (double)random.nextFloat(), 0.0, 0.04, 0.0);
        }
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        Fluid fluid = this.getFluid();
        level.scheduleTick(pos, fluid, fluid.getTickDelay((LevelReader)level));
        if (!state.canSurvive((LevelReader)level, pos)) {
            return fluid.defaultFluidState().createLegacyBlock();
        }
        if (facing == Direction.DOWN || facing == Direction.UP && !(facingState.getBlock() instanceof TFCBubbleColumnBlock) && TFCBubbleColumnBlock.canExistIn(facingState)) {
            level.scheduleTick(pos, (Block)this, 5);
        }
        return state;
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockState below = level.getBlockState(pos.below());
        return below.getBlock() instanceof TFCBubbleColumnBlock || below.getBlock() instanceof TFCMagmaBlock;
    }

    public ItemStack pickupBlock(@Nullable Player player, LevelAccessor level, BlockPos pos, BlockState state) {
        level.setBlock(pos, Blocks.AIR.defaultBlockState(), 11);
        return new ItemStack((ItemLike)this.getFluid().getBucket());
    }

    public Fluid getFluid() {
        return this.fluid.get();
    }
}

