/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks;

import java.util.function.ToIntFunction;
import net.dries007.tfc.common.blockentities.TickCounterBlockEntity;
import net.dries007.tfc.common.blocks.EntityBlockExtension;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.IForgeBlockExtension;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class TFCCandleBlock
extends CandleBlock
implements IForgeBlockExtension,
EntityBlockExtension {
    public static final ToIntFunction<BlockState> LIGHTING_SCALE = state -> (Boolean)state.getValue((Property)LIT) != false ? 3 * (Integer)state.getValue((Property)CANDLES) + 2 : 0;
    private final ExtendedProperties properties;

    public static void onRandomTick(BlockState state, ServerLevel level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TickCounterBlockEntity) {
            TickCounterBlockEntity candle = (TickCounterBlockEntity)blockEntity;
            int candleTicks = TFCConfig.SERVER.candleTicks.get();
            if (candle.getTicksSinceUpdate() > (long)candleTicks && candleTicks > 0) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    public TFCCandleBlock(ExtendedProperties properties) {
        super(properties.properties());
        this.properties = properties;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (Helpers.isItem(player.getMainHandItem(), (ItemLike)TFCItems.FIRESTARTER.get())) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    @Override
    public ExtendedProperties getExtendedProperties() {
        return this.properties;
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        TFCCandleBlock.onRandomTick(state, level, pos);
    }
}

