/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks;

import java.util.List;
import net.dries007.tfc.client.particle.TFCParticles;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.ThatchBedBlockEntity;
import net.dries007.tfc.common.blocks.EntityBlockExtension;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.IForgeBlockExtension;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.items.HideItemType;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class ThatchBedBlock
extends BedBlock
implements EntityBlockExtension,
IForgeBlockExtension {
    private static final VoxelShape BED_SHAPE = ThatchBedBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0);
    private final ExtendedProperties properties;

    public ThatchBedBlock(ExtendedProperties properties) {
        super(DyeColor.YELLOW, properties.properties());
        this.properties = properties;
    }

    @Override
    public ExtendedProperties getExtendedProperties() {
        return this.properties;
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return state.getValue((Property)PART) == BedPart.HEAD ? this.getExtendedProperties().newBlockEntity(pos, state) : null;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return ItemInteractionResult.CONSUME;
        }
        if (state.getValue((Property)PART) != BedPart.HEAD && !Helpers.isBlock(state = level.getBlockState(pos = pos.relative((Direction)state.getValue((Property)FACING))), (Block)this)) {
            return ItemInteractionResult.CONSUME;
        }
        if (!ThatchBedBlock.canSetSpawn((Level)level)) {
            level.removeBlock(pos, false);
            BlockPos blockpos = pos.relative(((Direction)state.getValue((Property)FACING)).getOpposite());
            if (Helpers.isBlock(level.getBlockState(blockpos), (Block)this)) {
                level.removeBlock(blockpos, false);
            }
            level.explode(null, level.damageSources().badRespawnPointExplosion(pos.getCenter()), null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 7.0f, true, Level.ExplosionInteraction.BLOCK);
            return ItemInteractionResult.SUCCESS;
        }
        if (((Boolean)state.getValue((Property)OCCUPIED)).booleanValue()) {
            if (!this.kickVillagerOutOfBed(level, pos)) {
                player.displayClientMessage((Component)Component.translatable((String)"block.minecraft.bed.occupied"), true);
            }
            return ItemInteractionResult.SUCCESS;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (level.isThundering() && TFCConfig.SERVER.thatchBedNoSleepInThunderstorms.get().booleanValue()) {
                player.displayClientMessage((Component)Component.translatable((String)"tfc.thatch_bed.thundering"), true);
                return ItemInteractionResult.SUCCESS;
            }
            boolean willSleep = TFCConfig.SERVER.enableThatchBedSleeping.get();
            boolean spawnPoint = TFCConfig.SERVER.enableThatchBedSpawnSetting.get();
            if (!willSleep) {
                if (spawnPoint) {
                    player.displayClientMessage((Component)Component.translatable((String)"tfc.thatch_bed.use_no_sleep_spawn"), true);
                    serverPlayer.setRespawnPosition(level.dimension(), pos, 0.0f, false, false);
                    return ItemInteractionResult.SUCCESS;
                }
                player.displayClientMessage((Component)Component.translatable((String)"tfc.thatch_bed.use_no_sleep_no_spawn"), true);
                return ItemInteractionResult.SUCCESS;
            }
            BlockPos lastRespawnPos = serverPlayer.getRespawnPosition();
            ResourceKey lastRespawnDimension = serverPlayer.getRespawnDimension();
            float lastRespawnAngle = serverPlayer.getRespawnAngle();
            player.startSleepInBed(pos).ifLeft(problem -> {
                if (problem.getMessage() != null) {
                    player.displayClientMessage(problem.getMessage(), true);
                }
            }).ifRight(unit -> {
                if (spawnPoint) {
                    player.displayClientMessage((Component)Component.translatable((String)"tfc.thatch_bed.use_sleep_spawn"), true);
                } else {
                    serverPlayer.setRespawnPosition(lastRespawnDimension, lastRespawnPos, lastRespawnAngle, false, false);
                    player.displayClientMessage((Component)Component.translatable((String)"tfc.thatch_bed.use_sleep_no_spawn"), true);
                }
            });
        }
        return ItemInteractionResult.SUCCESS;
    }

    public boolean addLandingEffects(BlockState state1, ServerLevel level, BlockPos pos, BlockState state2, LivingEntity entity, int numberOfParticles) {
        level.sendParticles((ParticleOptions)((SimpleParticleType)TFCParticles.FEATHER.get()), entity.getX(), Math.max(entity.getY() + (double)0.1f, (double)((float)pos.getY() + 0.6f)), entity.getZ(), numberOfParticles, 0.0, 0.0, 0.0, (double)0.15f);
        return super.addLandingEffects(state1, level, pos, state2, entity, numberOfParticles);
    }

    private boolean kickVillagerOutOfBed(Level level, BlockPos pos) {
        List list = level.getEntitiesOfClass(Villager.class, new AABB(pos), LivingEntity::isSleeping);
        if (list.isEmpty()) {
            return false;
        }
        ((Villager)list.get(0)).stopSleeping();
        return true;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return BED_SHAPE;
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Override
    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        if (state.getValue((Property)PART) == BedPart.FOOT) {
            pos = pos.relative((Direction)state.getValue((Property)FACING));
        }
        return level.getBlockEntity(pos, (BlockEntityType)TFCBlockEntities.THATCH_BED.get()).map(bed -> ((ItemStackHandler)bed.getInventory()).getStackInSlot(0).copy()).orElse(ItemStack.EMPTY);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        super.setPlacedBy(level, pos, state, entity, stack);
        level.getBlockEntity(pos.relative((Direction)state.getValue((Property)FACING)), (BlockEntityType)TFCBlockEntities.THATCH_BED.get()).ifPresent(bed -> {
            BlockState thatch = ((Block)TFCBlocks.THATCH.get()).defaultBlockState();
            bed.setBed(thatch, thatch, ((Item)TFCItems.HIDES.get((Object)HideItemType.RAW).get((Object)HideItemType.Size.LARGE).get()).getDefaultInstance());
        });
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getValue((Property)PART) == BedPart.HEAD && !Helpers.isBlock(state, newState.getBlock())) {
            level.getBlockEntity(pos, (BlockEntityType)TFCBlockEntities.THATCH_BED.get()).ifPresent(ThatchBedBlockEntity::destroyBed);
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }
}

