/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.crop;

import java.util.function.Supplier;
import net.dries007.tfc.common.blockentities.DecayingBlockEntity;
import net.dries007.tfc.common.blocks.EntityBlockExtension;
import net.dries007.tfc.common.blocks.ExtendedBlock;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.component.food.FoodCapability;
import net.dries007.tfc.common.component.food.IFood;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.Nullable;

public class DecayingBlock
extends ExtendedBlock
implements EntityBlockExtension {
    private final Supplier<? extends Block> rotted;

    public static boolean isRotten(Level level, BlockPos pos) {
        DecayingBlockEntity decaying;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        return blockEntity instanceof DecayingBlockEntity && (decaying = (DecayingBlockEntity)blockEntity).isRotten();
    }

    public DecayingBlock(ExtendedProperties properties, Supplier<? extends Block> rotted) {
        super(properties);
        this.rotted = rotted;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        super.setPlacedBy(level, pos, state, entity, stack);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof DecayingBlockEntity) {
            DecayingBlockEntity decaying = (DecayingBlockEntity)blockEntity;
            decaying.setStack(stack);
        }
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof DecayingBlockEntity) {
            DecayingBlockEntity decaying = (DecayingBlockEntity)blockEntity;
            if (player.isCreative()) {
                decaying.setStack(ItemStack.EMPTY);
            }
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity entity = level.getBlockEntity(pos);
        if (entity instanceof DecayingBlockEntity) {
            DecayingBlockEntity decaying = (DecayingBlockEntity)entity;
            if (!Helpers.isBlock(state, newState.getBlock())) {
                Helpers.spawnItem(level, pos, decaying.getStack());
            }
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        @Nullable IFood food = FoodCapability.get(context.getItemInHand());
        return food != null && food.isRotten() ? this.getRottedBlock().defaultBlockState() : this.defaultBlockState();
    }

    public Block getRottedBlock() {
        return this.rotted.get();
    }
}

