/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.crop;

import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.CropBlockEntity;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.crop.Crop;
import net.dries007.tfc.common.blocks.crop.CropBlock;
import net.dries007.tfc.common.blocks.crop.DeadCropBlock;
import net.dries007.tfc.common.blocks.crop.DeadDoubleCropBlock;
import net.dries007.tfc.common.blocks.crop.WildDoubleCropBlock;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.climate.ClimateRange;
import net.dries007.tfc.util.climate.ClimateRanges;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public abstract class DoubleCropBlock
extends CropBlock {
    public static final EnumProperty<Part> PART = TFCBlockStateProperties.DOUBLE_CROP_PART;
    protected final int maxSingleAge;
    protected final float maxSingleGrowth;

    public static DoubleCropBlock create(ExtendedProperties properties, int singleStages, int doubleStages, Crop crop) {
        final IntegerProperty property = TFCBlockStateProperties.getAgeProperty(singleStages + doubleStages - 1);
        return new DoubleCropBlock(properties, singleStages - 1, singleStages + doubleStages - 1, TFCBlocks.DEAD_CROPS.get((Object)crop), TFCItems.CROP_SEEDS.get((Object)crop), crop.getNitrogen(), crop.getPhosphorous(), crop.getPotassium(), ClimateRanges.CROPS.get((Object)crop)){

            @Override
            public IntegerProperty getAgeProperty() {
                return property;
            }
        };
    }

    protected DoubleCropBlock(ExtendedProperties properties, int maxSingleAge, int maxAge, Supplier<? extends Block> dead, Supplier<? extends Item> seeds, float nitrogen, float phosporous, float potassium, Supplier<ClimateRange> climateRange) {
        super(properties, maxAge, dead, seeds, nitrogen, phosporous, potassium, climateRange);
        this.maxSingleAge = maxSingleAge;
        this.maxSingleGrowth = (float)maxSingleAge / (float)maxAge;
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(PART, (Comparable)((Object)Part.BOTTOM)));
    }

    @Override
    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        Part part = (Part)((Object)state.getValue(PART));
        BlockState belowState = level.getBlockState(pos.below());
        if (part == Part.BOTTOM) {
            return Helpers.isBlock(belowState.getBlock(), TFCTags.Blocks.FARMLANDS);
        }
        return Helpers.isBlock(belowState, (Block)this) && belowState.getValue(PART) == Part.BOTTOM;
    }

    @Override
    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        Part part = (Part)((Object)state.getValue(PART));
        if (facing.getAxis() != Direction.Axis.Y || part == Part.BOTTOM != (facing == Direction.UP) || facingState.getBlock() == this && facingState.getValue(PART) != part) {
            return part == Part.BOTTOM && facing == Direction.DOWN && !state.canSurvive((LevelReader)level, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, facing, facingState, level, currentPos, facingPos);
        }
        return Blocks.AIR.defaultBlockState();
    }

    @Override
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        return super.useItemOn(stack, state, level, state.getValue(PART) == Part.TOP ? pos.below() : pos, player, hand, hitResult);
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        WildDoubleCropBlock.onPlayerWillDestroy(level, pos, state, player);
        return super.playerWillDestroy(level, pos, state, player);
    }

    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity tile, ItemStack stack) {
        super.playerDestroy(level, player, pos, Blocks.AIR.defaultBlockState(), tile, stack);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)builder.add(new Property[]{PART}));
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (state.getValue(PART) == Part.TOP) {
            return HALF_SHAPE;
        }
        float growth = (float)((Integer)state.getValue((Property)this.getAgeProperty())).intValue() / (float)this.maxSingleAge;
        if (growth <= 0.25f) {
            return QUARTER_SHAPE;
        }
        if (growth <= 0.5f) {
            return HALF_SHAPE;
        }
        return FULL_SHAPE;
    }

    @Override
    public void growthTick(Level level, BlockPos pos, BlockState state, CropBlockEntity crop) {
        if (state.getValue(PART) == Part.BOTTOM) {
            super.growthTick(level, pos, state, crop);
        }
    }

    @Override
    protected void postGrowthTick(Level level, BlockPos pos, BlockState state, CropBlockEntity crop) {
        BlockPos posAbove = pos.above();
        BlockState stateAbove = level.getBlockState(posAbove);
        int age = Mth.clamp((int)((int)(crop.getGrowth() * (float)this.getMaxAge())), (int)0, (int)this.getMaxAge());
        level.setBlock(pos, (BlockState)state.setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(age)), 2);
        if (age > this.maxSingleAge && (stateAbove.isAir() || stateAbove.getBlock() == this)) {
            level.setBlock(posAbove, (BlockState)((BlockState)state.setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(age))).setValue(PART, (Comparable)((Object)Part.TOP)), 3);
        }
    }

    @Override
    public float getGrowthLimit(Level level, BlockPos pos, BlockState state) {
        return this.isSameOrAir(level.getBlockState(pos.above())) ? super.getGrowthLimit(level, pos, state) : this.maxSingleGrowth;
    }

    @Override
    public void die(Level level, BlockPos pos, BlockState state, boolean fullyGrown) {
        BlockPos posAbove = pos.above();
        BlockState stateAbove = level.getBlockState(posAbove);
        BlockState deadState = (BlockState)((Block)this.dead.get()).defaultBlockState().setValue((Property)DeadCropBlock.MATURE, (Comparable)Boolean.valueOf(fullyGrown));
        if (fullyGrown && this.isSameOrAir(stateAbove)) {
            level.setBlock(posAbove, (BlockState)deadState.setValue(DeadDoubleCropBlock.PART, (Comparable)((Object)Part.TOP)), 18);
        } else if (stateAbove.getBlock() == this) {
            level.setBlockAndUpdate(posAbove, Blocks.AIR.defaultBlockState());
        }
        level.setBlockAndUpdate(pos, (BlockState)deadState.setValue(DeadDoubleCropBlock.PART, (Comparable)((Object)Part.BOTTOM)));
    }

    protected boolean isSameOrAir(BlockState state) {
        return state.isAir() || state.getBlock() == this;
    }

    @Override
    public void addHoeOverlayInfo(Level level, BlockPos pos, BlockState state, Consumer<Component> text, boolean isDebug) {
        super.addHoeOverlayInfo(level, state.getValue(PART) == Part.TOP ? pos.below() : pos, state, text, isDebug);
    }

    public static enum Part implements StringRepresentable
    {
        BOTTOM,
        TOP;

        private final String serializedName = this.name().toLowerCase(Locale.ROOT);

        public String getSerializedName() {
            return this.serializedName;
        }
    }
}

