/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.crop;

import java.util.function.Supplier;
import net.dries007.tfc.common.blockentities.CropBlockEntity;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.crop.ClimbingCropBlock;
import net.dries007.tfc.common.blocks.crop.Crop;
import net.dries007.tfc.common.blocks.crop.CropBlock;
import net.dries007.tfc.common.blocks.crop.DoubleCropBlock;
import net.dries007.tfc.common.blocks.crop.IPickableCrop;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.util.climate.ClimateRange;
import net.dries007.tfc.util.climate.ClimateRanges;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public abstract class PickableClimbingCropBlock
extends ClimbingCropBlock
implements IPickableCrop {
    @Nullable
    private final Supplier<Supplier<? extends Item>> fruit;
    private final Supplier<Supplier<? extends Item>> matureFruit;

    public static PickableClimbingCropBlock create(ExtendedProperties properties, int singleStages, int doubleStages, Crop crop, @Nullable Supplier<Supplier<? extends Item>> fruit, Supplier<Supplier<? extends Item>> matureFruit) {
        final IntegerProperty property = TFCBlockStateProperties.getAgeProperty(singleStages + doubleStages - 1);
        return new PickableClimbingCropBlock(properties, singleStages - 1, singleStages + doubleStages - 1, TFCBlocks.DEAD_CROPS.get((Object)crop), TFCItems.CROP_SEEDS.get((Object)crop), crop.getNitrogen(), crop.getPhosphorous(), crop.getPotassium(), ClimateRanges.CROPS.get((Object)crop), fruit, matureFruit){

            @Override
            public IntegerProperty getAgeProperty() {
                return property;
            }
        };
    }

    protected PickableClimbingCropBlock(ExtendedProperties properties, int maxSingleAge, int maxAge, Supplier<? extends Block> dead, Supplier<? extends Item> seeds, float nitrogen, float phosphorous, float potassium, Supplier<ClimateRange> climateRange, @Nullable Supplier<Supplier<? extends Item>> fruit, Supplier<Supplier<? extends Item>> matureFruit) {
        super(properties, maxSingleAge, maxAge, dead, seeds, nitrogen, phosphorous, potassium, climateRange);
        this.fruit = fruit;
        this.matureFruit = matureFruit;
    }

    @Override
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemInteractionResult res = super.useItemOn(stack, state, level, pos, player, hand, hitResult);
        if (res.consumesAction()) {
            return res;
        }
        BlockState belowState = level.getBlockState(pos.below());
        if (state.getValue((Property)PART) == DoubleCropBlock.Part.TOP && belowState.getBlock() instanceof PickableClimbingCropBlock) {
            return this.useItemOn(stack, belowState, level, pos.below(), player, hand, hitResult);
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CropBlockEntity) {
            CropBlockEntity crop = (CropBlockEntity)blockEntity;
            CropBlock cropBlock = (CropBlock)state.getBlock();
            float yield = crop.getYield();
            int age = (Integer)state.getValue((Property)cropBlock.getAgeProperty());
            RandomSource random = level.getRandom();
            int maxAge = cropBlock.getMaxAge();
            if (age == maxAge - 1 && this.getFirstFruit() != null) {
                crop.setGrowth(Mth.nextFloat((RandomSource)random, (float)0.4f, (float)0.5f));
                crop.setYield(0.0f);
                cropBlock.postGrowthTick(level, pos, state, crop);
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)this.yieldItemStack(this.getFirstFruit(), yield, random));
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (age == maxAge) {
                crop.setGrowth(Mth.nextFloat((RandomSource)random, (float)0.5f, (float)0.6f));
                crop.setYield(0.0f);
                cropBlock.postGrowthTick(level, pos, state, crop);
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)this.yieldItemStack(this.getSecondFruit(), yield, random));
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Override
    protected void postGrowthTick(Level level, BlockPos pos, BlockState state, CropBlockEntity crop) {
        BlockPos posAbove = pos.above();
        BlockState stateAbove = level.getBlockState(posAbove);
        int age = Mth.clamp((int)((int)(crop.getGrowth() * (float)this.getMaxAge())), (int)0, (int)this.getMaxAge());
        if (stateAbove.getBlock() instanceof PickableClimbingCropBlock && age <= this.maxSingleAge) {
            age = this.maxSingleAge + 1;
        }
        level.setBlock(pos, (BlockState)state.setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(age)), 2);
        if (age > this.maxSingleAge && (stateAbove.isAir() || stateAbove.getBlock() == this)) {
            level.setBlock(posAbove, (BlockState)((BlockState)state.setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(age))).setValue((Property)PART, (Comparable)((Object)DoubleCropBlock.Part.TOP)), 3);
        }
    }

    @Override
    @Nullable
    public Item getFirstFruit() {
        return this.fruit == null ? null : this.fruit.get().get();
    }

    @Override
    public Item getSecondFruit() {
        return this.matureFruit.get().get();
    }
}

