/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.crop;

import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.crop.CropBlock;
import net.dries007.tfc.common.blocks.crop.DoubleCropBlock;
import net.dries007.tfc.common.blocks.crop.WildCropBlock;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class WildDoubleCropBlock
extends WildCropBlock {
    public static final EnumProperty<DoubleCropBlock.Part> PART = TFCBlockStateProperties.DOUBLE_CROP_PART;

    public static void onPlayerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.isClientSide) {
            if (player.isCreative()) {
                BlockPos blockpos;
                BlockState blockstate;
                if (state.getValue(PART) == DoubleCropBlock.Part.TOP && (blockstate = level.getBlockState(blockpos = pos.below())).getBlock() == state.getBlock() && blockstate.getValue(PART) == DoubleCropBlock.Part.BOTTOM) {
                    level.setBlock(blockpos, Blocks.AIR.defaultBlockState(), 35);
                    level.levelEvent(player, 2001, blockpos, Block.getId((BlockState)blockstate));
                }
            } else {
                WildDoubleCropBlock.dropResources((BlockState)state, (Level)level, (BlockPos)pos, (BlockEntity)level.getBlockEntity(pos), (Entity)player, (ItemStack)player.getMainHandItem());
            }
        }
    }

    public static boolean doubleBlockSurvives(BlockState state, LevelReader level, BlockPos pos) {
        DoubleCropBlock.Part part = (DoubleCropBlock.Part)((Object)state.getValue(PART));
        BlockState belowState = level.getBlockState(pos.below());
        if (part == DoubleCropBlock.Part.BOTTOM) {
            return Helpers.isBlock(belowState.getBlock(), TFCTags.Blocks.WILD_CROP_GROWS_ON);
        }
        return Helpers.isBlock(belowState, state.getBlock()) && belowState.getValue(PART) == DoubleCropBlock.Part.BOTTOM;
    }

    public WildDoubleCropBlock(ExtendedProperties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue(PART, (Comparable)((Object)DoubleCropBlock.Part.BOTTOM))).setValue((Property)MATURE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        super.randomTick(state, level, pos, random);
        if (state.getValue(PART) == DoubleCropBlock.Part.TOP) {
            BlockState below = level.getBlockState(pos.below());
            if (below.getBlock() == this && (Boolean)below.getValue((Property)MATURE) != WildDoubleCropBlock.isMature((Level)level, pos)) {
                level.setBlockAndUpdate(pos.below(), (BlockState)below.cycle((Property)MATURE));
            }
        } else {
            BlockState above = level.getBlockState(pos.above());
            if (above.getBlock() == this && (Boolean)above.getValue((Property)MATURE) != WildDoubleCropBlock.isMature((Level)level, pos)) {
                level.setBlockAndUpdate(pos.above(), (BlockState)above.cycle((Property)MATURE));
            }
        }
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return state.getValue(PART) == DoubleCropBlock.Part.BOTTOM ? CropBlock.FULL_SHAPE : CropBlock.HALF_SHAPE;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)builder.add(new Property[]{PART}));
    }

    @Override
    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return WildDoubleCropBlock.doubleBlockSurvives(state, level, pos);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        DoubleCropBlock.Part part = (DoubleCropBlock.Part)((Object)state.getValue(PART));
        if (facing.getAxis() != Direction.Axis.Y || part == DoubleCropBlock.Part.BOTTOM != (facing == Direction.UP) || facingState.getBlock() == this && facingState.getValue(PART) != part) {
            return part == DoubleCropBlock.Part.BOTTOM && facing == Direction.DOWN && !state.canSurvive((LevelReader)level, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, facing, facingState, level, currentPos, facingPos);
        }
        return Blocks.AIR.defaultBlockState();
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos = context.getClickedPos();
        return pos.getY() < context.getLevel().getMaxBuildHeight() - 1 && context.getLevel().getBlockState(pos.above()).canBeReplaced(context) ? super.getStateForPlacement(context) : null;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (placer instanceof Player) {
            level.setBlockAndUpdate(pos.above(), (BlockState)state.setValue(PART, (Comparable)((Object)DoubleCropBlock.Part.TOP)));
        }
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        WildDoubleCropBlock.onPlayerWillDestroy(level, pos, state, player);
        return super.playerWillDestroy(level, pos, state, player);
    }

    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity tile, ItemStack stack) {
        super.playerDestroy(level, player, pos, Blocks.AIR.defaultBlockState(), tile, stack);
    }

    public void placeTwoHalves(LevelAccessor level, BlockPos pos, int flags) {
        level.setBlock(pos, (BlockState)this.defaultBlockState().setValue(PART, (Comparable)((Object)DoubleCropBlock.Part.BOTTOM)), flags);
        level.setBlock(pos.above(), (BlockState)this.defaultBlockState().setValue(PART, (Comparable)((Object)DoubleCropBlock.Part.TOP)), flags);
    }
}

