/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.devices;

import java.util.List;
import java.util.Optional;
import net.dries007.tfc.common.blockentities.CrucibleBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.DirectionPropertyBlock;
import net.dries007.tfc.common.blocks.EntityBlockExtension;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TooltipBlock;
import net.dries007.tfc.common.blocks.devices.ChannelBlock;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.dries007.tfc.common.component.TFCComponents;
import net.dries007.tfc.common.component.block.CrucibleComponent;
import net.dries007.tfc.common.component.size.IItemSize;
import net.dries007.tfc.common.component.size.Size;
import net.dries007.tfc.common.component.size.Weight;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.tooltip.Tooltips;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.fluids.FluidStack;

public class CrucibleBlock
extends DeviceBlock
implements EntityBlockExtension,
IItemSize,
TooltipBlock {
    private static final VoxelShape[] SHAPES = new VoxelShape[16];
    private static final VoxelShape INTERACTION_SHAPE;
    private static final BooleanProperty NORTH;
    private static final BooleanProperty EAST;
    private static final BooleanProperty SOUTH;
    private static final BooleanProperty WEST;

    public CrucibleBlock(ExtendedProperties properties) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.SAVE);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false)));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!player.isShiftKeyDown()) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                level.getBlockEntity(pos, (BlockEntityType)TFCBlockEntities.CRUCIBLE.get()).ifPresent(crucible -> serverPlayer.openMenu((MenuProvider)crucible, crucible.getBlockPos()));
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPES[((Boolean)state.getValue((Property)NORTH) != false ? 1 << Direction.NORTH.get2DDataValue() : 0) | ((Boolean)state.getValue((Property)EAST) != false ? 1 << Direction.EAST.get2DDataValue() : 0) | ((Boolean)state.getValue((Property)SOUTH) != false ? 1 << Direction.SOUTH.get2DDataValue() : 0) | ((Boolean)state.getValue((Property)WEST) != false ? 1 << Direction.WEST.get2DDataValue() : 0)];
    }

    protected VoxelShape getInteractionShape(BlockState state, BlockGetter level, BlockPos pos) {
        return INTERACTION_SHAPE;
    }

    @Override
    public Size getSize(ItemStack stack) {
        return Size.LARGE;
    }

    @Override
    public Weight getWeight(ItemStack stack) {
        return ((CrucibleComponent)stack.getOrDefault(TFCComponents.CRUCIBLE, (Object)CrucibleComponent.EMPTY)).isEmpty() ? Weight.HEAVY : Weight.VERY_HEAVY;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState adjacentState, LevelAccessor level, BlockPos pos, BlockPos adjacentPos) {
        for (Direction planeDirection : Direction.Plane.HORIZONTAL) {
            BlockPos thisAdjacentPos = pos.relative(planeDirection);
            BlockState thisAdjacentState = level.getBlockState(thisAdjacentPos);
            Block adjancentBlock = thisAdjacentState.getBlock();
            boolean isAdjacentConnectable = adjancentBlock instanceof ChannelBlock;
            state = (BlockState)state.setValue((Property)DirectionPropertyBlock.getProperty(planeDirection), (Comparable)Boolean.valueOf(isAdjacentConnectable));
        }
        return state;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{EAST, SOUTH, WEST, NORTH});
    }

    protected boolean hasAnalogOutputSignal(BlockState state) {
        return TFCConfig.SERVER.crucibleEnableAutomation.get();
    }

    protected int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        CrucibleBlockEntity crucible;
        FluidStack fluid;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CrucibleBlockEntity && !(fluid = ((CrucibleBlockEntity.CrucibleInventory)(crucible = (CrucibleBlockEntity)blockEntity).getInventory()).getFluidInTank(0)).isEmpty()) {
            return Mth.clamp((int)(fluid.getAmount() * 15 / TFCConfig.SERVER.crucibleCapacity.get()), (int)1, (int)15);
        }
        return 0;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        CrucibleComponent component = (CrucibleComponent)stack.getOrDefault(TFCComponents.CRUCIBLE, (Object)CrucibleComponent.EMPTY);
        if (!component.isEmpty()) {
            FluidStack fluid;
            if (!TFCConfig.CLIENT.displayItemContentsAsImages.get().booleanValue()) {
                tooltip.add((Component)Component.translatable((String)"tfc.tooltip.small_vessel.contents").withStyle(ChatFormatting.DARK_GREEN));
                Helpers.addInventoryTooltipInfo(component.itemContent(), tooltip);
            }
            if (!(fluid = component.fluidContent().getResult()).isEmpty()) {
                tooltip.add((Component)Tooltips.fluidUnitsOf(fluid));
            }
        }
    }

    @Override
    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        return TFCConfig.CLIENT.displayItemContentsAsImages.get() != false ? TooltipBlock.buildInventoryTooltip(((CrucibleComponent)stack.getOrDefault(TFCComponents.CRUCIBLE, (Object)CrucibleComponent.EMPTY)).itemContent().subList(0, 9), 3, 3) : Optional.empty();
    }

    static {
        VoxelShape base = Shapes.or((VoxelShape)CrucibleBlock.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)2.0, (double)13.0), (VoxelShape[])new VoxelShape[]{CrucibleBlock.box((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)16.0, (double)3.0), CrucibleBlock.box((double)1.0, (double)1.0, (double)13.0, (double)15.0, (double)16.0, (double)15.0), CrucibleBlock.box((double)13.0, (double)1.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0), CrucibleBlock.box((double)1.0, (double)1.0, (double)1.0, (double)3.0, (double)16.0, (double)15.0)});
        VoxelShape east = CrucibleBlock.box((double)15.0, (double)0.0, (double)5.0, (double)16.0, (double)5.0, (double)11.0);
        VoxelShape south = CrucibleBlock.box((double)5.0, (double)0.0, (double)15.0, (double)11.0, (double)5.0, (double)16.0);
        VoxelShape west = CrucibleBlock.box((double)0.0, (double)0.0, (double)5.0, (double)1.0, (double)5.0, (double)11.0);
        VoxelShape north = CrucibleBlock.box((double)5.0, (double)0.0, (double)0.0, (double)11.0, (double)5.0, (double)1.0);
        VoxelShape[] directions = new VoxelShape[]{south, west, north, east};
        for (int i = 0; i < SHAPES.length; ++i) {
            VoxelShape shape = base;
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                if ((i >> direction.get2DDataValue() & 1) != 1) continue;
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)directions[direction.get2DDataValue()]);
            }
            CrucibleBlock.SHAPES[i] = shape;
        }
        INTERACTION_SHAPE = Shapes.or((VoxelShape)CrucibleBlock.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)2.0, (double)13.0), (VoxelShape)CrucibleBlock.box((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0));
        NORTH = PipeBlock.NORTH;
        EAST = PipeBlock.EAST;
        SOUTH = PipeBlock.SOUTH;
        WEST = PipeBlock.WEST;
    }
}

