/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.devices;

import java.util.function.Supplier;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TickCounterBlockEntity;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.devices.BottomSupportedDeviceBlock;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class DryingBricksBlock
extends BottomSupportedDeviceBlock {
    public static final IntegerProperty COUNT = TFCBlockStateProperties.COUNT_1_4;
    public static final BooleanProperty DRIED = TFCBlockStateProperties.DRIED;
    public static final VoxelShape SHAPE_1 = DryingBricksBlock.box((double)2.0, (double)0.0, (double)1.0, (double)6.0, (double)3.0, (double)7.0);
    public static final VoxelShape SHAPE_2 = Shapes.or((VoxelShape)SHAPE_1, (VoxelShape)DryingBricksBlock.box((double)10.0, (double)0.0, (double)1.0, (double)14.0, (double)3.0, (double)7.0));
    public static final VoxelShape SHAPE_3 = Shapes.or((VoxelShape)SHAPE_2, (VoxelShape)DryingBricksBlock.box((double)2.0, (double)0.0, (double)9.0, (double)6.0, (double)3.0, (double)15.0));
    public static final VoxelShape SHAPE_4 = Shapes.or((VoxelShape)SHAPE_3, (VoxelShape)DryingBricksBlock.box((double)10.0, (double)0.0, (double)9.0, (double)14.0, (double)3.0, (double)15.0));
    private final Supplier<? extends Item> dryItem;

    public DryingBricksBlock(ExtendedProperties properties, Supplier<? extends Item> dryItem) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.NOOP, SHAPE_1);
        this.dryItem = dryItem;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)COUNT, (Comparable)Integer.valueOf(1))).setValue((Property)DRIED, (Comparable)Boolean.valueOf(false)));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (Helpers.isItem(stack, (ItemLike)this.asItem()) && !player.isShiftKeyDown() && !((Boolean)state.getValue((Property)DRIED)).booleanValue()) {
            int count = (Integer)state.getValue((Property)COUNT);
            if (count < 4) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)COUNT, (Comparable)Integer.valueOf(count + 1)));
                this.playSound(state, level, pos, (Entity)player);
                TickCounterBlockEntity.reset(level, pos);
                if (!player.isCreative()) {
                    stack.shrink(1);
                }
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
        } else if (stack.isEmpty() && player.isShiftKeyDown()) {
            int count = (Integer)state.getValue((Property)COUNT);
            ItemStack drop = new ItemStack((ItemLike)((Boolean)state.getValue((Property)DRIED) != false ? (ItemLike)this.dryItem.get() : this.asItem()));
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)drop);
            if (count > 1) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)COUNT, (Comparable)Integer.valueOf(count - 1)));
            } else {
                level.setBlockAndUpdate(pos, state.getFluidState().createLegacyBlock());
            }
            this.playSound(state, level, pos, (Entity)player);
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos;
        Level level = context.getLevel();
        BlockState state = level.getBlockState(pos = context.getClickedPos());
        if (!state.getFluidState().isEmpty()) {
            return null;
        }
        if (state.getBlock() == this && !((Boolean)state.getValue((Property)DRIED)).booleanValue() && (Integer)state.getValue((Property)COUNT) < 4) {
            return (BlockState)state.setValue((Property)COUNT, (Comparable)Integer.valueOf((Integer)state.getValue((Property)COUNT) + 1));
        }
        return super.getStateForPlacement(context);
    }

    @Override
    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return (Boolean)state.getValue((Property)DRIED) != false ? this.dryItem.get().getDefaultInstance() : super.getCloneItemStack(state, target, level, pos, player);
    }

    protected boolean canBeReplaced(BlockState state, BlockPlaceContext context) {
        return !context.isSecondaryUseActive() && Helpers.isItem(context.getItemInHand(), (ItemLike)this.asItem()) && (Integer)state.getValue((Property)COUNT) < 4 && (Boolean)state.getValue((Property)DRIED) == false || super.canBeReplaced(state, context);
    }

    private void playSound(BlockState state, Level level, BlockPos pos, @Nullable Entity entity) {
        SoundType soundType = this.getSoundType(state, (LevelReader)level, pos, entity);
        level.playSound(null, pos, soundType.getPlaceSound(), SoundSource.BLOCKS, (soundType.getVolume() + 1.0f) / 2.0f, soundType.getPitch() * 0.8f);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        TickCounterBlockEntity.reset(level, pos);
        super.setPlacedBy(level, pos, state, placer, stack);
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Integer)state.getValue((Property)COUNT)) {
            case 2 -> SHAPE_2;
            case 3 -> SHAPE_3;
            case 4 -> SHAPE_4;
            default -> SHAPE_1;
        };
    }

    public boolean isRandomlyTicking(BlockState state) {
        return (Boolean)state.getValue((Property)DRIED) == false;
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        this.tick(state, level, pos, random);
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        if (((Boolean)state.getValue((Property)DRIED)).booleanValue()) {
            return;
        }
        level.getBlockEntity(pos, (BlockEntityType)TFCBlockEntities.TICK_COUNTER.get()).ifPresent(counter -> {
            if (level.isRainingAt(pos.above())) {
                counter.resetCounter();
            } else {
                int ticks = TFCConfig.SERVER.mudBricksTicks.get();
                if (ticks > -1 && counter.getTicksSinceUpdate() > (long)ticks) {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)DRIED, (Comparable)Boolean.valueOf(true)));
                    BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
                    for (Direction d : Direction.Plane.HORIZONTAL) {
                        cursor.setWithOffset((Vec3i)pos, d);
                        BlockState stateAt = level.getBlockState((BlockPos)cursor);
                        if (!(stateAt.getBlock() instanceof DryingBricksBlock)) continue;
                        level.scheduleTick((BlockPos)cursor, stateAt.getBlock(), 1);
                    }
                }
            }
        });
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{COUNT, DRIED}));
    }
}

