/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.devices;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.common.blockentities.PitKilnBlockEntity;
import net.dries007.tfc.common.blockentities.PlacedItemBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.EntityBlockExtension;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.IForgeBlockExtension;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PlacedItemBlock
extends DeviceBlock
implements IForgeBlockExtension,
EntityBlockExtension {
    public static final BooleanProperty ITEM_0 = TFCBlockStateProperties.ITEM_0;
    public static final BooleanProperty ITEM_1 = TFCBlockStateProperties.ITEM_1;
    public static final BooleanProperty ITEM_2 = TFCBlockStateProperties.ITEM_2;
    public static final BooleanProperty ITEM_3 = TFCBlockStateProperties.ITEM_3;
    public static final BooleanProperty[] ITEM_PROPERTIES = new BooleanProperty[]{ITEM_0, ITEM_1, ITEM_2, ITEM_3};
    private static final VoxelShape SHAPE_0 = PlacedItemBlock.box((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)1.0, (double)16.0);
    private static final VoxelShape SHAPE_1 = PlacedItemBlock.box((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)1.0, (double)16.0);
    private static final VoxelShape SHAPE_2 = PlacedItemBlock.box((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)8.0);
    private static final VoxelShape SHAPE_3 = PlacedItemBlock.box((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)1.0, (double)8.0);
    private static final VoxelShape[] SHAPES = new VoxelShape[]{SHAPE_0, SHAPE_1, SHAPE_2, SHAPE_3};
    private final boolean persistentWhenEmpty;
    private final Map<BlockState, VoxelShape> cachedShapes;

    public static boolean isEmptyContents(BlockState state) {
        for (BooleanProperty property : ITEM_PROPERTIES) {
            if (!((Boolean)state.getValue((Property)property)).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static boolean isFullContents(BlockState state) {
        for (BooleanProperty property : ITEM_PROPERTIES) {
            if (((Boolean)state.getValue((Property)property)).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static boolean isSlotSupported(BlockState state, BlockHitResult rayTrace) {
        return (Boolean)state.getValue((Property)ITEM_PROPERTIES[PlacedItemBlockEntity.getSlotSelected(rayTrace)]);
    }

    public static BlockState updateStateValues(LevelAccessor level, BlockPos pos, BlockState state) {
        VoxelShape shapeBelow = level.getBlockState(pos).getBlockSupportShape((BlockGetter)level, pos).getFaceShape(Direction.UP);
        for (int slot = 0; slot < 4; ++slot) {
            state = (BlockState)state.setValue((Property)ITEM_PROPERTIES[slot], (Comparable)Boolean.valueOf(!Shapes.joinIsNotEmpty((VoxelShape)shapeBelow, (VoxelShape)SHAPES[slot], (BooleanOp)BooleanOp.ONLY_SECOND)));
        }
        return state;
    }

    private static Map<BlockState, VoxelShape> makeShapes(ImmutableList<BlockState> possibleStates, VoxelShape emptyShape) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : possibleStates) {
            VoxelShape shape = emptyShape;
            for (int i = 0; i < 4; ++i) {
                if (!((Boolean)state.getValue((Property)ITEM_PROPERTIES[i])).booleanValue()) continue;
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)SHAPES[i]);
            }
            builder.put((Object)state, (Object)shape);
        }
        return builder.build();
    }

    public PlacedItemBlock(ExtendedProperties properties) {
        this(properties, Shapes.empty(), false);
    }

    protected PlacedItemBlock(ExtendedProperties properties, VoxelShape emptyShape, boolean persistentWhenEmpty) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.DROP);
        this.cachedShapes = PlacedItemBlock.makeShapes((ImmutableList<BlockState>)this.getStateDefinition().getPossibleStates(), emptyShape);
        this.persistentWhenEmpty = persistentWhenEmpty;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)ITEM_0, (Comparable)Boolean.valueOf(true))).setValue((Property)ITEM_1, (Comparable)Boolean.valueOf(true))).setValue((Property)ITEM_2, (Comparable)Boolean.valueOf(true))).setValue((Property)ITEM_3, (Comparable)Boolean.valueOf(true)));
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        BlockState updateState = PlacedItemBlock.updateStateValues(level, pos.below(), state);
        if (!this.persistentWhenEmpty && PlacedItemBlock.isEmptyContents(updateState)) {
            return Blocks.AIR.defaultBlockState();
        }
        return updateState;
    }

    @Override
    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        level.getBlockEntity(pos, this.getExtendedProperties().blockEntity()).ifPresent(entity -> entity.ejectInventoryIfNeeded(newState));
        if (!(!state.hasBlockEntity() || Helpers.isBlock(state, newState.getBlock()) && newState.hasBlockEntity())) {
            level.removeBlockEntity(pos);
        }
    }

    @Override
    protected void beforeRemove(InventoryBlockEntity<?> entity) {
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        PlacedItemBlockEntity placedItem = level.getBlockEntity(pos, (BlockEntityType)TFCBlockEntities.PLACED_ITEM.get()).orElse(null);
        if (placedItem != null) {
            ItemStack held = player.getItemInHand(hand);
            if (!held.isEmpty() && (Helpers.isItem(held.getItem(), TFCTags.Items.PIT_KILN_STRAW) || Helpers.isItem(held.getItem(), TFCTags.Items.PIT_KILN_4_STRAW)) && PitKilnBlockEntity.isValid(level, pos)) {
                if (!level.isClientSide()) {
                    PlacedItemBlockEntity.convertPlacedItemToPitKiln(level, pos, held.split(1));
                }
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            return placedItem.onRightClick(player, held, hitResult) ? ItemInteractionResult.sidedSuccess((boolean)level.isClientSide) : ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.cachedShapes.get(state);
    }

    protected VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ITEM_0, ITEM_1, ITEM_2, ITEM_3});
    }

    @Override
    public ItemStack getCloneItemStack(BlockState state, HitResult result, LevelReader level, BlockPos pos, Player player) {
        ItemStack backup;
        ItemStack itemStack = backup = this.asItem() == Items.AIR ? ItemStack.EMPTY : new ItemStack((ItemLike)this.asItem());
        if (result instanceof BlockHitResult) {
            BlockHitResult blockResult = (BlockHitResult)result;
            return level.getBlockEntity(pos, (BlockEntityType)TFCBlockEntities.PLACED_ITEM.get()).map(placedItem -> placedItem.getCloneItemStack(state, blockResult)).orElse(backup);
        }
        return backup;
    }
}

