/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant;

import java.util.function.Supplier;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.plant.KelpTreeBlock;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.fluids.FluidProperty;
import net.dries007.tfc.common.fluids.IFluidLoggable;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;
import org.jetbrains.annotations.Nullable;

public abstract class KelpTreeFlowerBlock
extends Block
implements IFluidLoggable {
    public static final IntegerProperty AGE = BlockStateProperties.AGE_5;
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    private static final VoxelShape SHAPE = Block.box((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);
    private final Supplier<? extends Block> bodyBlock;

    public static KelpTreeFlowerBlock create(BlockBehaviour.Properties builder, Supplier<? extends Block> plant) {
        return new KelpTreeFlowerBlock(builder, (Supplier)plant){

            @Override
            public FluidProperty getFluidProperty() {
                return TFCBlockStateProperties.SALT_WATER;
            }
        };
    }

    protected KelpTreeFlowerBlock(BlockBehaviour.Properties builder, Supplier<? extends Block> bodyBlock) {
        super(builder);
        this.bodyBlock = bodyBlock;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue((Property)this.getFluidProperty(), (Comparable)this.getFluidProperty().keyFor(Fluids.EMPTY))).setValue((Property)FACING, (Comparable)Direction.UP));
    }

    public boolean isRandomlyTicking(BlockState state) {
        return (Integer)state.getValue((Property)AGE) < 5;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{this.getFluidProperty(), AGE, FACING});
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        FluidHelpers.tickFluid(level, currentPos, state, true);
        if (!state.canSurvive((LevelReader)level, currentPos)) {
            level.scheduleTick(currentPos, (Block)this, 1);
            return Blocks.AIR.defaultBlockState();
        }
        return state;
    }

    @Override
    public FluidState getFluidState(BlockState state) {
        return IFluidLoggable.super.getFluidState(state);
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        if (state.getFluidState().isEmpty()) {
            return false;
        }
        KelpTreeBlock body = (KelpTreeBlock)this.getBodyBlock().get();
        BlockState blockstate = level.getBlockState(pos.below());
        if (blockstate.getBlock() != body && !Helpers.isBlock(blockstate, TFCTags.Blocks.SEA_BUSH_PLANTABLE_ON)) {
            if (!this.isEmptyWaterBlock(level, pos.below())) {
                return false;
            }
            boolean isValid = false;
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockState relativeState = level.getBlockState(pos.relative(direction));
                if (Helpers.isBlock(relativeState, (Block)body)) {
                    if (isValid) {
                        return false;
                    }
                    isValid = true;
                    continue;
                }
                if (this.isEmptyWaterBlock(level, pos.relative(direction))) continue;
                return false;
            }
            return isValid;
        }
        return true;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int i;
        KelpTreeBlock body = (KelpTreeBlock)this.getBodyBlock().get();
        Fluid fluid = ((FluidProperty.FluidKey)state.getValue((Property)this.getFluidProperty())).getFluid();
        BlockPos abovePos = pos.above();
        if (this.isEmptyWaterBlock((LevelReader)level, abovePos) && abovePos.getY() < level.getMaxBuildHeight() && TFCConfig.SERVER.plantLongGrowthChance.get() > random.nextDouble() && (i = ((Integer)state.getValue((Property)AGE)).intValue()) < 5 && CommonHooks.canCropGrow((Level)level, (BlockPos)abovePos, (BlockState)state, (boolean)true)) {
            boolean shouldPlaceNewBody = false;
            boolean foundGroundFurtherDown = false;
            BlockState belowState = level.getBlockState(pos.below());
            Block belowBlock = belowState.getBlock();
            if (Helpers.isBlock(belowBlock, TFCTags.Blocks.SEA_BUSH_PLANTABLE_ON)) {
                shouldPlaceNewBody = true;
            } else if (belowBlock == body) {
                int j = 1;
                for (int k = 0; k < 4; ++k) {
                    Block belowBlockOffset = level.getBlockState(pos.below(j + 1)).getBlock();
                    if (belowBlockOffset != body) {
                        if (!Helpers.isBlock(belowBlockOffset, TFCTags.Blocks.SEA_BUSH_PLANTABLE_ON)) break;
                        foundGroundFurtherDown = true;
                        break;
                    }
                    ++j;
                }
                if (j < 2 || j <= random.nextInt(foundGroundFurtherDown ? 5 : 4)) {
                    shouldPlaceNewBody = true;
                }
            } else if (this.isEmptyWaterBlock((LevelReader)level, pos.below())) {
                shouldPlaceNewBody = true;
            }
            if (shouldPlaceNewBody && this.allNeighborsEmpty((LevelReader)level, abovePos, null) && this.isEmptyWaterBlock((LevelReader)level, pos.above(2))) {
                this.setBodyBlockWithFluid((LevelAccessor)level, pos, fluid);
                this.placeGrownFlower((LevelAccessor)level, abovePos, i, Direction.UP);
            } else if (i < 4) {
                int l = random.nextInt(4);
                if (foundGroundFurtherDown) {
                    ++l;
                }
                boolean foundValidGrowthSpace = false;
                for (int i1 = 0; i1 < l; ++i1) {
                    Direction direction = Direction.Plane.HORIZONTAL.getRandomDirection(random);
                    BlockPos relativePos = pos.relative(direction);
                    if (!this.isEmptyWaterBlock((LevelReader)level, relativePos) || !this.isEmptyWaterBlock((LevelReader)level, relativePos.below()) || !this.allNeighborsEmpty((LevelReader)level, relativePos, direction.getOpposite())) continue;
                    this.placeGrownFlower((LevelAccessor)level, relativePos, i + 1, direction);
                    foundValidGrowthSpace = true;
                }
                if (foundValidGrowthSpace) {
                    this.setBodyBlockWithFluid((LevelAccessor)level, pos, fluid);
                } else {
                    this.placeDeadFlower((LevelAccessor)level, pos, (Direction)level.getBlockState(pos).getValue((Property)FACING));
                }
            } else {
                this.placeDeadFlower((LevelAccessor)level, pos, (Direction)level.getBlockState(pos).getValue((Property)FACING));
            }
            CommonHooks.fireCropGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        if (!state.canSurvive((LevelReader)level, pos)) {
            level.destroyBlock(pos, true);
        }
    }

    public boolean generatePlant(LevelAccessor level, BlockPos pos, RandomSource rand, int maxHorizontalDistance, Fluid fluid, int seaLevel) {
        if (this.getFluidProperty().canContain(fluid)) {
            BlockState originalState = level.getBlockState(pos);
            this.setBodyBlockWithFluid(level, pos, fluid);
            if (level.getBlockState(pos).canSurvive((LevelReader)level, pos) && this.growTreeRecursive(level, pos, rand, pos, maxHorizontalDistance, 0, fluid, seaLevel)) {
                return true;
            }
            level.setBlock(pos, originalState, 3);
        }
        return false;
    }

    public boolean growTreeRecursive(LevelAccessor level, BlockPos branchPos, RandomSource rand, BlockPos originalBranchPos, int maxHorizontalDistance, int iterations, Fluid fluid, int seaLevel) {
        boolean any = false;
        int i = rand.nextInt(5) + 1;
        if (iterations == 0) {
            ++i;
        }
        for (int j = 0; j < i; ++j) {
            BlockPos blockpos = branchPos.above(j + 1);
            if (!this.allNeighborsEmpty((LevelReader)level, blockpos, null) || blockpos.getY() >= seaLevel - 2) {
                return any;
            }
            if (blockpos.getY() == seaLevel - 3) {
                this.placeGrownFlower(level, blockpos, 5, Direction.UP);
            } else {
                this.setBodyBlockWithFluid(level, blockpos, fluid);
            }
            this.setBodyBlockWithFluid(level, blockpos.below(), fluid);
        }
        boolean willContinue = false;
        if (iterations < 4) {
            int branchAttempts = rand.nextInt(4);
            if (iterations == 0) {
                ++branchAttempts;
            }
            for (int k = 0; k < branchAttempts; ++k) {
                Direction direction = Direction.Plane.HORIZONTAL.getRandomDirection(rand);
                BlockPos aboveRelativePos = branchPos.above(i).relative(direction);
                if (Math.abs(aboveRelativePos.getX() - originalBranchPos.getX()) >= maxHorizontalDistance || Math.abs(aboveRelativePos.getZ() - originalBranchPos.getZ()) >= maxHorizontalDistance || !this.isEmptyWaterBlock((LevelReader)level, aboveRelativePos) || !this.isEmptyWaterBlock((LevelReader)level, aboveRelativePos.below()) || !this.allNeighborsEmpty((LevelReader)level, aboveRelativePos, direction.getOpposite())) continue;
                willContinue = true;
                this.setBodyBlockWithFluid(level, aboveRelativePos, fluid);
                this.setBodyBlockWithFluid(level, aboveRelativePos.relative(direction.getOpposite()), fluid);
                this.growTreeRecursive(level, aboveRelativePos, rand, originalBranchPos, maxHorizontalDistance, iterations + 1, fluid, seaLevel);
            }
        }
        if (!willContinue) {
            level.setBlock(branchPos.above(i), (BlockState)((BlockState)this.defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(rand.nextInt(10) == 1 ? 3 : 5))).setValue((Property)this.getFluidProperty(), (Comparable)this.getFluidProperty().keyFor(fluid)), 2);
        }
        return true;
    }

    protected boolean isEmptyWaterBlock(LevelReader level, BlockPos pos) {
        return level.getBlockState(pos).getBlock() == TFCBlocks.SALT_WATER.get();
    }

    protected boolean allNeighborsEmpty(LevelReader level, BlockPos pos, @Nullable Direction excludingSide) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (direction == excludingSide || this.isEmptyWaterBlock(level, pos.relative(direction))) continue;
            return false;
        }
        return true;
    }

    protected void placeGrownFlower(LevelAccessor level, BlockPos pos, int age, Direction facing) {
        Fluid fluid = level.getFluidState(pos).getType();
        BlockState state = (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)this.getFluidProperty(), (Comparable)this.getFluidProperty().keyFor(fluid))).setValue((Property)AGE, (Comparable)Integer.valueOf(age))).setValue((Property)FACING, (Comparable)facing);
        if (state.canSurvive((LevelReader)level, pos)) {
            level.setBlock(pos, state, 2);
        }
    }

    protected void placeDeadFlower(LevelAccessor level, BlockPos pos, Direction facing) {
        Fluid fluid = level.getFluidState(pos).getType();
        BlockState state = (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)this.getFluidProperty(), (Comparable)this.getFluidProperty().keyFor(fluid))).setValue((Property)AGE, (Comparable)Integer.valueOf(5))).setValue((Property)FACING, (Comparable)facing);
        if (state.canSurvive((LevelReader)level, pos)) {
            level.setBlock(pos, state, 2);
        }
    }

    protected void setBodyBlockWithFluid(LevelAccessor level, BlockPos pos, Fluid fluid) {
        BlockState state = this.getBodyStateWithFluid(level, pos, fluid);
        level.setBlock(pos, state, 2);
    }

    protected BlockState getBodyStateWithFluid(LevelAccessor level, BlockPos pos, Fluid fluid) {
        KelpTreeBlock plant = (KelpTreeBlock)this.getBodyBlock().get();
        return (BlockState)plant.getStateForPlacement((BlockGetter)level, pos).setValue((Property)this.getFluidProperty(), (Comparable)this.getFluidProperty().keyFor(fluid));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidState;
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Direction direction = context.getClickedFace();
        BlockState state = this.defaultBlockState();
        if (world.getBlockState(pos.relative(direction.getOpposite())).is(this.getBodyBlock().get())) {
            state = (BlockState)state.setValue((Property)FACING, (Comparable)context.getClickedFace());
        }
        if (!(fluidState = world.getFluidState(context.getClickedPos())).isEmpty() && this.getFluidProperty().canContain(fluidState.getType())) {
            return (BlockState)state.setValue((Property)this.getFluidProperty(), (Comparable)this.getFluidProperty().keyFor(fluidState.getType()));
        }
        return null;
    }

    protected Supplier<? extends Block> getBodyBlock() {
        return this.bodyBlock;
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }
}

