/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant;

import net.dries007.tfc.common.blocks.ExtendedBlock;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.devices.BottomSupportedDeviceBlock;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class KrummholzBlock
extends ExtendedBlock {
    public static final VoxelShape NORMAL_SHAPE = KrummholzBlock.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    public static final VoxelShape TIP_SHAPE = KrummholzBlock.box((double)6.5, (double)0.0, (double)6.5, (double)9.5, (double)12.0, (double)9.5);
    public static final VoxelShape SNOW_SHAPE = KrummholzBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    public static final VoxelShape NORMAL_WITH_SNOW_SHAPE = Shapes.or((VoxelShape)NORMAL_SHAPE, (VoxelShape)SNOW_SHAPE);
    public static final VoxelShape TIP_WITH_SNOW_SHAPE = Shapes.or((VoxelShape)TIP_SHAPE, (VoxelShape)SNOW_SHAPE);
    public static final BooleanProperty TIP = TFCBlockStateProperties.TIP;
    public static final BooleanProperty SNOWY = BlockStateProperties.SNOWY;
    public static final BooleanProperty BOTTOM = TFCBlockStateProperties.BOTTOM;

    public static void updateFreezingInColumn(LevelAccessor level, BlockPos pos, boolean frozen) {
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        BlockState state = level.getBlockState(pos);
        cursor.set((Vec3i)pos);
        while (state.getBlock() instanceof KrummholzBlock) {
            if ((Boolean)state.getValue((Property)SNOWY) != frozen) {
                level.setBlock((BlockPos)cursor, (BlockState)state.cycle((Property)SNOWY), 2);
            }
            cursor.move(0, -1, 0);
            state = level.getBlockState((BlockPos)cursor);
        }
    }

    public KrummholzBlock(ExtendedProperties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)TIP, (Comparable)Boolean.valueOf(false))).setValue((Property)SNOWY, (Comparable)Boolean.valueOf(false))).setValue((Property)BOTTOM, (Comparable)Boolean.valueOf(false)));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.getItem() == Items.SNOW && !((Boolean)state.getValue((Property)SNOWY)).booleanValue()) {
            level.setBlockAndUpdate(pos, (BlockState)state.cycle((Property)SNOWY));
            stack.shrink(1);
            Helpers.playPlaceSound(player, (LevelAccessor)level, pos, SoundType.SNOW);
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        if (facing == Direction.DOWN && !state.canSurvive((LevelReader)level, pos)) {
            level.scheduleTick(pos, (Block)this, 1);
        } else {
            if (facing == Direction.DOWN) {
                return (BlockState)state.setValue((Property)BOTTOM, (Comparable)Boolean.valueOf(facingState.getBlock() != this));
            }
            if (facing == Direction.UP) {
                return (BlockState)state.setValue((Property)TIP, (Comparable)Boolean.valueOf(facingState.getBlock() != this));
            }
        }
        return state;
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!state.canSurvive((LevelReader)level, pos)) {
            level.destroyBlock(pos, true);
        }
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)TIP, (Comparable)Boolean.valueOf(true))).setValue((Property)BOTTOM, (Comparable)Boolean.valueOf(context.getLevel().getBlockState(context.getClickedPos().below()).getBlock() != this));
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockState below = level.getBlockState(pos.below());
        return below.getBlock() == this || BottomSupportedDeviceBlock.canSurvive(level, pos);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        boolean addSnow;
        boolean bl = addSnow = (Boolean)state.getValue((Property)BOTTOM) != false && (Boolean)state.getValue((Property)SNOWY) != false;
        return ((Boolean)state.getValue((Property)TIP)).booleanValue() ? (addSnow ? TIP_WITH_SNOW_SHAPE : TIP_SHAPE) : (addSnow ? NORMAL_WITH_SNOW_SHAPE : NORMAL_SHAPE);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{TIP, SNOWY, BOTTOM}));
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    public boolean isCollisionShapeFullBlock(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return false;
    }
}

