/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BambooStalkBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BambooLeaves;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.common.util.TriState;

public class TFCBambooStalkBlock
extends BambooStalkBlock {
    private final Supplier<? extends Block> sapling;

    public TFCBambooStalkBlock(BlockBehaviour.Properties properties, Supplier<? extends Block> sapling) {
        super(properties);
        this.sapling = sapling;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        if (!fluidstate.isEmpty()) {
            return null;
        }
        BlockState state = context.getLevel().getBlockState(context.getClickedPos().below());
        TriState soilDecision = state.canSustainPlant((BlockGetter)context.getLevel(), context.getClickedPos().below(), Direction.UP, this.defaultBlockState());
        if (soilDecision.isDefault() ? !Helpers.isBlock(state, (TagKey<Block>)BlockTags.BAMBOO_PLANTABLE_ON) : !soilDecision.isTrue()) {
            return null;
        }
        if (Helpers.isBlock(state, TFCTags.Blocks.BAMBOO_SAPLING)) {
            return (BlockState)this.defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(0));
        }
        if (Helpers.isBlock(state, TFCTags.Blocks.BAMBOO)) {
            int i = (Integer)state.getValue((Property)AGE) > 0 ? 1 : 0;
            return (BlockState)this.defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(i));
        }
        BlockState aboveState = context.getLevel().getBlockState(context.getClickedPos().above());
        return Helpers.isBlock(aboveState, TFCTags.Blocks.BAMBOO) ? (BlockState)this.defaultBlockState().setValue((Property)AGE, (Comparable)((Integer)aboveState.getValue((Property)AGE))) : this.sapling.get().defaultBlockState();
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (!state.canSurvive((LevelReader)level, pos)) {
            level.scheduleTick(pos, (Block)this, 1);
        }
        if (direction == Direction.UP && Helpers.isBlock(neighborState, TFCTags.Blocks.BAMBOO) && (Integer)neighborState.getValue((Property)AGE) > (Integer)state.getValue((Property)AGE)) {
            level.setBlock(pos, (BlockState)state.cycle((Property)AGE), 2);
        }
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    protected void growBamboo(BlockState state, Level level, BlockPos pos, RandomSource random, int age) {
        BlockState belowState = level.getBlockState(pos.below());
        BlockPos belowPos2 = pos.below(2);
        BlockState belowState2 = level.getBlockState(belowPos2);
        BambooLeaves leafState = BambooLeaves.NONE;
        if (age >= 1) {
            if (Helpers.isBlock(belowState2, TFCTags.Blocks.BAMBOO) && belowState.getValue((Property)LEAVES) != BambooLeaves.NONE) {
                if (Helpers.isBlock(belowState, TFCTags.Blocks.BAMBOO) && belowState.getValue((Property)LEAVES) != BambooLeaves.NONE) {
                    leafState = BambooLeaves.LARGE;
                    if (belowState2.is(TFCTags.Blocks.BAMBOO)) {
                        level.setBlock(pos.below(), (BlockState)belowState.setValue((Property)LEAVES, (Comparable)BambooLeaves.SMALL), 3);
                        level.setBlock(belowPos2, (BlockState)belowState2.setValue((Property)LEAVES, (Comparable)BambooLeaves.NONE), 3);
                    }
                }
            } else {
                leafState = BambooLeaves.SMALL;
            }
        }
        int newAge = (Integer)state.getValue((Property)AGE) != 1 && !belowState2.is(TFCTags.Blocks.BAMBOO) ? 0 : 1;
        int newStage = !(age >= 11 && random.nextFloat() < 0.25f || age == 15) ? 0 : 1;
        level.setBlock(pos.above(), (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(newAge))).setValue((Property)LEAVES, (Comparable)leafState)).setValue((Property)STAGE, (Comparable)Integer.valueOf(newStage)), 3);
    }

    protected int getHeightAboveUpToMax(BlockGetter level, BlockPos pos) {
        int i;
        for (i = 0; i < 16 && level.getBlockState(pos.above(i + 1)).is(TFCTags.Blocks.BAMBOO); ++i) {
        }
        return i;
    }

    protected int getHeightBelowUpToMax(BlockGetter level, BlockPos pos) {
        int i;
        for (i = 0; i < 16 && level.getBlockState(pos.below(i + 1)).is(TFCTags.Blocks.BAMBOO); ++i) {
        }
        return i;
    }
}

