/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant;

import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.plant.ITallPlant;
import net.dries007.tfc.common.blocks.plant.TFCTallGrassBlock;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.fluids.FluidProperty;
import net.dries007.tfc.common.fluids.IFluidLoggable;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.registry.RegistryPlant;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public abstract class TallWaterPlantBlock
extends TFCTallGrassBlock
implements IFluidLoggable {
    public static final EnumProperty<ITallPlant.Part> PART = TFCBlockStateProperties.TALL_PLANT_PART;

    public static TallWaterPlantBlock create(final RegistryPlant plant, final FluidProperty fluid, BlockBehaviour.Properties properties) {
        return new TallWaterPlantBlock(ExtendedProperties.of(properties)){

            @Override
            public RegistryPlant getPlant() {
                return plant;
            }

            @Override
            public FluidProperty getFluidProperty() {
                return fluid;
            }
        };
    }

    protected TallWaterPlantBlock(ExtendedProperties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)this.getFluidProperty(), (Comparable)this.getFluidProperty().keyFor(Fluids.EMPTY))).setValue(PART, (Comparable)((Object)ITallPlant.Part.LOWER)));
    }

    @Override
    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        FluidHelpers.tickFluid(level, currentPos, state);
        return super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    @Override
    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockState belowState = level.getBlockState(pos.below());
        if (state.getValue(PART) == ITallPlant.Part.LOWER) {
            if (Helpers.isBlock(state, TFCTags.Blocks.HALOPHYTE)) {
                return Helpers.isBlock(belowState, TFCTags.Blocks.HALOPHYTE_PLANTABLE_ON);
            }
            return Helpers.isBlock(belowState, TFCTags.Blocks.SEA_BUSH_PLANTABLE_ON);
        }
        if (state.getBlock() != this) {
            return Helpers.isBlock(belowState, TFCTags.Blocks.SEA_BUSH_PLANTABLE_ON);
        }
        return belowState.getBlock() == this && belowState.getValue(PART) == ITallPlant.Part.LOWER;
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos = context.getClickedPos();
        FluidState fluidState = context.getLevel().getFluidState(pos);
        BlockState state = this.defaultBlockState();
        if (this.getFluidProperty().canContain(fluidState.getType())) {
            state = (BlockState)state.setValue((Property)this.getFluidProperty(), (Comparable)this.getFluidProperty().keyFor(fluidState.getType()));
        }
        return pos.getY() < context.getLevel().getMaxBuildHeight() - 1 && context.getLevel().getBlockState(pos.above()).canBeReplaced(context) ? state : null;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)builder.add(new Property[]{this.getFluidProperty()}));
    }

    @Override
    public void placeTwoHalves(LevelAccessor level, BlockPos pos, int flags, RandomSource random) {
        BlockPos posAbove = pos.above();
        Fluid fluidBottom = level.getFluidState(pos).getType();
        Fluid fluidTop = level.getFluidState(posAbove).getType();
        if (!fluidBottom.isSame(Fluids.EMPTY)) {
            BlockState state = FluidHelpers.fillWithFluid((BlockState)this.defaultBlockState().setValue(PART, (Comparable)((Object)ITallPlant.Part.LOWER)), fluidBottom);
            BlockState stateUp = FluidHelpers.fillWithFluid((BlockState)this.defaultBlockState().setValue(PART, (Comparable)((Object)ITallPlant.Part.UPPER)), fluidTop);
            if (state != null && stateUp != null) {
                level.setBlock(pos, state, flags);
                level.setBlock(posAbove, stateUp, flags);
            }
        }
    }

    @Override
    public FluidState getFluidState(BlockState state) {
        return IFluidLoggable.super.getFluidState(state);
    }
}

