/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant.fruit;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.client.overworld.SolarCalculator;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.BerryBushBlockEntity;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.plant.fruit.Lifecycle;
import net.dries007.tfc.common.blocks.plant.fruit.SeasonalPlantBlock;
import net.dries007.tfc.common.blocks.soil.FarmlandBlock;
import net.dries007.tfc.common.blocks.soil.HoeOverlayBlock;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.Month;
import net.dries007.tfc.util.climate.Climate;
import net.dries007.tfc.util.climate.ClimateRange;
import net.dries007.tfc.util.climate.ClimateRanges;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BananaPlantBlock
extends SeasonalPlantBlock
implements HoeOverlayBlock {
    public static final VoxelShape PLANT = BananaPlantBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)6.0, (double)14.0);
    private static final VoxelShape TRUNK_0 = BananaPlantBlock.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final VoxelShape TRUNK_1 = BananaPlantBlock.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);

    public static void kill(Level level, BlockPos pos) {
        Block deadBlock = (Block)TFCBlocks.DEAD_BANANA_PLANT.get();
        if (!level.isClientSide) {
            BlockState foundState;
            BlockState deadState = deadBlock.defaultBlockState();
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos().set((Vec3i)pos.below());
            while (Helpers.isBlock(foundState = level.getBlockState((BlockPos)mutable), (Block)TFCBlocks.BANANA_PLANT.get())) {
                level.setBlockAndUpdate((BlockPos)mutable, (BlockState)deadState.setValue((Property)STAGE, (Comparable)((Integer)foundState.getValue((Property)STAGE))));
                mutable.move(Direction.DOWN);
            }
        }
    }

    public BananaPlantBlock(ExtendedProperties properties, Supplier<? extends Item> productItem, Lifecycle[] stages) {
        super(properties, ClimateRanges.BANANA_PLANT, productItem, stages);
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockPos basePos;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BerryBushBlockEntity) {
            BerryBushBlockEntity plant = (BerryBushBlockEntity)blockEntity;
            basePos = plant.getStemPos();
        } else {
            basePos = pos;
        }
        int hydration = BananaPlantBlock.getFruitBushHydrationFromRootPos((Level)level, basePos);
        float temp = Climate.getAverageTemperature((Level)level, basePos);
        if (((ClimateRange)this.climateRange.get()).checkBoth(hydration, temp, false)) {
            this.tick(state, level, pos, random);
        } else {
            BananaPlantBlock.kill((Level)level, pos);
        }
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        BerryBushBlockEntity counter;
        int maxCycles;
        Block block = state.getBlock();
        if (block instanceof SeasonalPlantBlock) {
            SeasonalPlantBlock plant = (SeasonalPlantBlock)block;
            plant.onUpdate((Level)level, pos, state);
        }
        if (((Lifecycle)((Object)level.getBlockState(pos).getValue((Property)LIFECYCLE))).active() && (block = level.getBlockEntity(pos)) instanceof BerryBushBlockEntity && (maxCycles = (int)((counter = (BerryBushBlockEntity)block).getTicksSinceUpdate() / (long)TFCConfig.SERVER.bananaPlantGrowthTicks.get().intValue())) >= 1) {
            long previousTick;
            maxCycles = Math.min(maxCycles, 8);
            int cycles = 0;
            int daysInMonth = Calendars.SERVER.getCalendarDaysInMonth();
            long currentTick = Calendars.SERVER.getTicks();
            if (currentTick - (previousTick = counter.getLastUpdateTick()) >= 24000L * (long)daysInMonth * 8L) {
                cycles = 8;
            } else {
                Lifecycle lifecycle;
                Month month;
                long simulatedCalendarTick;
                long simulatedTick;
                boolean checkReverseDirection = false;
                for (simulatedTick = previousTick; cycles < maxCycles && simulatedTick < currentTick; ++cycles, simulatedTick += (long)TFCConfig.SERVER.bananaPlantGrowthTicks.get().intValue()) {
                    simulatedCalendarTick = Calendars.SERVER.getCalendarTickFromOffset(simulatedTick - currentTick);
                    month = Calendars.SERVER.getHemispheralCalendarMonthOfYear(SolarCalculator.getInNorthernHemisphere(pos, (Level)level), simulatedCalendarTick, daysInMonth);
                    lifecycle = this.getLifecycleForMonth(month);
                    if (lifecycle != Lifecycle.DORMANT) {
                        continue;
                    }
                    checkReverseDirection = true;
                    break;
                }
                if (checkReverseDirection) {
                    for (simulatedTick = currentTick; cycles < maxCycles && simulatedTick > previousTick; ++cycles, simulatedTick -= (long)TFCConfig.SERVER.bananaPlantGrowthTicks.get().intValue()) {
                        simulatedCalendarTick = Calendars.SERVER.getCalendarTickFromOffset(simulatedTick - currentTick);
                        month = Calendars.SERVER.getHemispheralCalendarMonthOfYear(SolarCalculator.getInNorthernHemisphere(pos, (Level)level), simulatedCalendarTick, daysInMonth);
                        lifecycle = this.getLifecycleForMonth(month);
                        if (lifecycle == Lifecycle.DORMANT) break;
                    }
                }
            }
            counter.resetCounter();
            if (cycles > 0) {
                this.grow(state, level, pos, rand, cycles - 1);
            }
        }
    }

    @Override
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemInteractionResult result = super.useItemOn(stack, state, level, pos, player, hand, hitResult);
        if (result.consumesAction()) {
            BananaPlantBlock.kill(level, pos);
        }
        return result;
    }

    @Override
    public BlockState stateAfterPicking(BlockState state) {
        return (BlockState)((Block)TFCBlocks.DEAD_BANANA_PLANT.get()).defaultBlockState().setValue((Property)STAGE, (Comparable)Integer.valueOf(2));
    }

    @Override
    public void addHoeOverlayInfo(Level level, BlockPos pos, BlockState state, Consumer<Component> text, boolean isDebug) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BerryBushBlockEntity) {
            BerryBushBlockEntity bush = (BerryBushBlockEntity)blockEntity;
            ClimateRange range = (ClimateRange)this.climateRange.get();
            BlockPos sourcePos = bush.getStemPos().below();
            int hydration = BananaPlantBlock.getFruitBushHydration(level, pos);
            text.accept(FarmlandBlock.getHydrationTooltip(range, false, hydration));
            text.accept(FarmlandBlock.getAverageTemperatureTooltip(level, sourcePos, range, false));
        }
    }

    @Override
    public ItemStack getProductItem(RandomSource random) {
        return new ItemStack((ItemLike)this.productItem.get(), Mth.nextInt((RandomSource)random, (int)3, (int)6));
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Integer)state.getValue((Property)STAGE)) {
            case 0 -> TRUNK_0;
            case 1 -> TRUNK_1;
            default -> PLANT;
        };
    }

    @Override
    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Integer)state.getValue((Property)STAGE) == 2 ? Shapes.empty() : this.getShape(state, level, pos, context);
    }

    @Override
    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
    }

    protected void grow(BlockState state, ServerLevel level, BlockPos pos, RandomSource random, int cycles) {
        BlockPos abovePos;
        --cycles;
        int oldStage = (Integer)state.getValue((Property)STAGE);
        if (oldStage == 1 && level.isEmptyBlock(abovePos = pos.above()) && level.canSeeSky(abovePos)) {
            int distanceToGround = BananaPlantBlock.distanceToGround((Level)level, pos, 6);
            if (distanceToGround < random.nextInt(3, 6)) {
                BlockState newState = (BlockState)state.setValue((Property)STAGE, (Comparable)Integer.valueOf(0));
                this.placeTrunk(level, abovePos, pos, state, newState, cycles);
                return;
            }
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)STAGE, (Comparable)Integer.valueOf(2)));
        }
    }

    /*
     * Unable to fully structure code
     */
    private void placeTrunk(ServerLevel level, BlockPos newPos, BlockPos oldPos, BlockState newPosState, BlockState oldPosState, int cycles) {
        level.setBlockAndUpdate(newPos, newPosState);
        level.setBlockAndUpdate(oldPos, oldPosState);
        var9_7 = level.getBlockEntity(oldPos);
        if (!(var9_7 instanceof BerryBushBlockEntity)) ** GOTO lbl-1000
        sourceBush = (BerryBushBlockEntity)var9_7;
        var9_7 = level.getBlockEntity(newPos);
        if (var9_7 instanceof BerryBushBlockEntity) {
            newBush = (BerryBushBlockEntity)var9_7;
            newBush.resetCounter();
            newBush.increaseCounter((long)TFCConfig.SERVER.bananaPlantGrowthTicks.get().intValue() * (long)cycles);
            newBush.setStemPos(sourceBush.getStemPos());
        } else lbl-1000:
        // 2 sources

        {
            TerraFirmaCraft.LOGGER.error("Failed to update growing berry bush block entity at: {}", (Object)oldPos);
        }
        level.getBlockState(newPos).tick(level, newPos, level.random);
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if ((Integer)state.getValue((Property)STAGE) == 2 && newState.isAir()) {
            BananaPlantBlock.kill(level, pos);
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    @Override
    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos belowPos = pos.below();
        BlockState belowState = level.getBlockState(belowPos);
        return Helpers.isBlock(belowState, TFCTags.Blocks.BUSH_PLANTABLE_ON) || Helpers.isBlock(belowState, (Block)this);
    }
}

