/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant.fruit;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.BerryBushBlockEntity;
import net.dries007.tfc.common.blockentities.TickingPlantBlockEntity;
import net.dries007.tfc.common.blocks.EntityBlockExtension;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.plant.fruit.FruitTreeBranchBlock;
import net.dries007.tfc.common.blocks.soil.FarmlandBlock;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.climate.Climate;
import net.dries007.tfc.util.climate.ClimateRange;
import net.dries007.tfc.util.tracker.WorldTracker;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class GrowingFruitTreeBranchBlock
extends FruitTreeBranchBlock
implements EntityBlockExtension {
    public static final IntegerProperty SAPLINGS = TFCBlockStateProperties.SAPLINGS;
    public static final BooleanProperty NATURAL = TFCBlockStateProperties.NATURAL;
    private static final Direction[] NOT_DOWN = new Direction[]{Direction.WEST, Direction.EAST, Direction.SOUTH, Direction.NORTH, Direction.UP};
    private final Supplier<? extends Block> body;
    private final Supplier<? extends Block> leaves;
    private final Supplier<ClimateRange> climateRange;

    private static boolean canGrowInto(LevelReader level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        return state.isAir() || Helpers.isBlock(state, TFCTags.Blocks.FRUIT_TREE_LEAVES);
    }

    private static boolean allNeighborsEmpty(LevelReader level, BlockPos pos, @Nullable Direction excludingSide) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            mutablePos.set((Vec3i)pos).move(direction);
            if (direction == excludingSide || GrowingFruitTreeBranchBlock.canGrowInto(level, (BlockPos)mutablePos)) continue;
            return false;
        }
        return true;
    }

    public GrowingFruitTreeBranchBlock(ExtendedProperties properties, Supplier<? extends Block> body, Supplier<? extends Block> leaves, Supplier<ClimateRange> climateRange) {
        super(properties, climateRange);
        this.body = body;
        this.leaves = leaves;
        this.climateRange = climateRange;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(true))).setValue((Property)STAGE, (Comparable)Integer.valueOf(0))).setValue((Property)NATURAL, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public void addExtraInfo(Consumer<Component> text) {
        text.accept((Component)Component.translatable((String)"tfc.tooltip.fruit_tree.growing"));
    }

    public void grow(BlockState state, ServerLevel level, BlockPos pos, RandomSource random, int cyclesLeft) {
        BlockEntity blockEntity;
        --cyclesLeft;
        FruitTreeBranchBlock body = (FruitTreeBranchBlock)this.body.get();
        BlockPos abovePos = pos.above();
        boolean natural = (Boolean)state.getValue((Property)NATURAL);
        if (GrowingFruitTreeBranchBlock.canGrowInto((LevelReader)level, abovePos) && abovePos.getY() < level.getMaxBuildHeight() - 1 && (blockEntity = level.getBlockEntity(pos)) instanceof TickingPlantBlockEntity) {
            TickingPlantBlockEntity activeBranch = (TickingPlantBlockEntity)blockEntity;
            BlockPos stemPos = activeBranch.getStemPos();
            int stage = (Integer)state.getValue((Property)STAGE);
            if (stage < 3) {
                boolean willGrowUpward = false;
                BlockState belowState = level.getBlockState(pos.below());
                Block belowBlock = belowState.getBlock();
                if (Helpers.isBlock(belowBlock, TFCTags.Blocks.BUSH_PLANTABLE_ON)) {
                    willGrowUpward = true;
                } else if (belowBlock == body) {
                    BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
                    int j = 1;
                    for (int k = 0; k < 4; ++k) {
                        mutablePos.setWithOffset((Vec3i)pos, 0, -1 * (j + 1), 0);
                        if (level.getBlockState((BlockPos)mutablePos).getBlock() != body) break;
                        ++j;
                    }
                    if (j < 2) {
                        willGrowUpward = true;
                    }
                } else if (GrowingFruitTreeBranchBlock.canGrowInto((LevelReader)level, pos.below())) {
                    willGrowUpward = true;
                }
                if (willGrowUpward && GrowingFruitTreeBranchBlock.allNeighborsEmpty((LevelReader)level, abovePos, null) && GrowingFruitTreeBranchBlock.canGrowInto((LevelReader)level, pos.above(2))) {
                    this.placeBody((LevelAccessor)level, pos, stemPos, stage);
                    this.placeGrownFlower(level, abovePos, stemPos, stage, (Integer)state.getValue((Property)SAPLINGS), cyclesLeft, natural);
                } else if (stage < 2) {
                    int branches = Math.max(0, (Integer)state.getValue((Property)SAPLINGS) - stage);
                    BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
                    List directions = Direction.Plane.HORIZONTAL.stream().collect(Collectors.toList());
                    while (branches > 0) {
                        Direction test = Direction.Plane.HORIZONTAL.getRandomDirection(random);
                        if (!directions.contains(test)) continue;
                        if (GrowingFruitTreeBranchBlock.couldBranchInDirection(level, pos, mutablePos, test)) {
                            boolean doubleBranch = false;
                            if (random.nextBoolean()) {
                                mutablePos.move(test, 1);
                                if (GrowingFruitTreeBranchBlock.couldBranchInDirection(level, pos, mutablePos, test)) {
                                    mutablePos.move(test, -1);
                                    this.placeBody((LevelAccessor)level, (BlockPos)mutablePos, stemPos, stage);
                                    mutablePos.move(test, 1);
                                    this.placeGrownFlower(level, (BlockPos)mutablePos, stemPos, stage + 1, (Integer)state.getValue((Property)SAPLINGS), cyclesLeft, natural);
                                    doubleBranch = true;
                                }
                            }
                            if (!doubleBranch) {
                                this.placeGrownFlower(level, (BlockPos)mutablePos, stemPos, stage + 1, (Integer)state.getValue((Property)SAPLINGS), cyclesLeft, natural);
                            }
                        }
                        directions.remove(test);
                        --branches;
                    }
                    this.placeBody((LevelAccessor)level, pos, stemPos, stage);
                }
            } else {
                this.placeBody((LevelAccessor)level, pos, stemPos, stage);
            }
        }
    }

    private static boolean couldBranchInDirection(ServerLevel level, BlockPos pos, BlockPos.MutableBlockPos mutablePos, Direction test) {
        mutablePos.setWithOffset((Vec3i)pos, test);
        if (GrowingFruitTreeBranchBlock.canGrowInto((LevelReader)level, (BlockPos)mutablePos)) {
            mutablePos.move(0, -1, 0);
            if (GrowingFruitTreeBranchBlock.canGrowInto((LevelReader)level, (BlockPos)mutablePos)) {
                mutablePos.move(0, 1, 0);
                return GrowingFruitTreeBranchBlock.allNeighborsEmpty((LevelReader)level, (BlockPos)mutablePos, test.getOpposite());
            }
        }
        return false;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)builder.add(new Property[]{SAPLINGS, NATURAL}));
    }

    public boolean isRandomlyTicking(BlockState state) {
        return (Integer)state.getValue((Property)STAGE) < 3;
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int hydration = GrowingFruitTreeBranchBlock.getFruitBranchHydration((Level)level, pos);
        float temp = Climate.getAverageTemperature((Level)level, pos);
        if (!this.climateRange.get().checkBoth(hydration, temp, false) && !((Boolean)state.getValue((Property)NATURAL)).booleanValue()) {
            TickingPlantBlockEntity.reset((Level)level, pos);
        } else {
            this.tick(state, level, pos, random);
        }
        super.randomTick(state, level, pos, random);
    }

    @Override
    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        TickingPlantBlockEntity counter;
        int cycles;
        super.tick(state, level, pos, rand);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TickingPlantBlockEntity && (cycles = (int)((counter = (TickingPlantBlockEntity)blockEntity).getTicksSinceUpdate() / (long)TFCConfig.SERVER.fruitBranchGrowthTicks.get().intValue())) >= 1) {
            counter.resetCounter();
            this.grow(state, level, pos, rand, cycles);
        }
    }

    private void placeGrownFlower(ServerLevel level, BlockPos childPos, BlockPos stemPos, int stage, int saplings, int cycles, boolean natural) {
        BlockState newState = (BlockState)((BlockState)((BlockState)this.getStateForPlacement((BlockGetter)level, childPos).setValue((Property)STAGE, (Comparable)Integer.valueOf(stage))).setValue((Property)SAPLINGS, (Comparable)Integer.valueOf(saplings))).setValue((Property)NATURAL, (Comparable)Boolean.valueOf(natural));
        level.setBlock(childPos, newState, 3);
        BlockEntity blockEntity = level.getBlockEntity(childPos);
        if (blockEntity instanceof TickingPlantBlockEntity) {
            TickingPlantBlockEntity counter = (TickingPlantBlockEntity)blockEntity;
            counter.resetCounter();
            counter.increaseCounter(24000L * (long)cycles * 5L);
            counter.setStemPos(stemPos);
            this.addLeaves((LevelAccessor)level, childPos, stemPos);
        } else {
            TerraFirmaCraft.LOGGER.error("Failed to update fruit tree branch block entity at: {}", (Object)childPos);
        }
        level.getBlockState(childPos).randomTick(level, childPos, level.random);
    }

    private void placeBody(LevelAccessor level, BlockPos bodyPos, BlockPos stemPos, int stage) {
        FruitTreeBranchBlock plant = (FruitTreeBranchBlock)this.body.get();
        level.setBlock(bodyPos, (BlockState)plant.getStateForPlacement((BlockGetter)level, bodyPos).setValue((Property)STAGE, (Comparable)Integer.valueOf(stage)), 3);
        this.addLeaves(level, bodyPos, stemPos);
    }

    private void addLeaves(LevelAccessor level, BlockPos centerPos, BlockPos stemPos) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        BlockState leaves = this.leaves.get().defaultBlockState();
        mutablePos.setWithOffset((Vec3i)centerPos, 0, -2, 0);
        BlockState downState = level.getBlockState((BlockPos)mutablePos);
        if (!(downState.isAir() || Helpers.isBlock(downState, TFCTags.Blocks.FRUIT_TREE_LEAVES) || Helpers.isBlock(downState, TFCTags.Blocks.FRUIT_TREE_BRANCH))) {
            return;
        }
        for (Direction d : NOT_DOWN) {
            mutablePos.setWithOffset((Vec3i)centerPos, d);
            if (!level.isEmptyBlock((BlockPos)mutablePos)) continue;
            level.setBlock((BlockPos)mutablePos, leaves, 3);
            BlockEntity blockEntity = level.getBlockEntity((BlockPos)mutablePos);
            if (!(blockEntity instanceof BerryBushBlockEntity)) continue;
            BerryBushBlockEntity leaf = (BerryBushBlockEntity)blockEntity;
            leaf.setStemPos(stemPos);
        }
    }

    protected static int getFruitBranchHydration(Level level, BlockPos leafPos) {
        BlockPos sourcePos;
        BlockEntity blockEntity = level.getBlockEntity(leafPos);
        if (blockEntity instanceof TickingPlantBlockEntity) {
            TickingPlantBlockEntity branch = (TickingPlantBlockEntity)blockEntity;
            sourcePos = branch.getStemPos().below();
        } else {
            TerraFirmaCraft.LOGGER.error("Fruit tree leaf block entity not present at {}", (Object)leafPos);
            sourcePos = leafPos;
        }
        return GrowingFruitTreeBranchBlock.getFruitBranchHydrationFromRootPos(level, sourcePos);
    }

    protected static int getFruitBranchHydrationFromRootPos(Level level, BlockPos rootPos) {
        float averageRainfall = WorldTracker.get(level).getClimateModel().getAverageRainfall((LevelReader)level, rootPos);
        return FarmlandBlock.getHydrationFromRainHydration(level, rootPos, FarmlandBlock.getRainHydration(averageRainfall));
    }
}

