/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant.fruit;

import com.google.common.base.Preconditions;
import com.mojang.serialization.MapCodec;
import java.util.function.Supplier;
import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.client.overworld.SolarCalculator;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.BerryBushBlockEntity;
import net.dries007.tfc.common.blockentities.TickCounterBlockEntity;
import net.dries007.tfc.common.blocks.EntityBlockExtension;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.IForgeBlockExtension;
import net.dries007.tfc.common.blocks.ISlowEntities;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.plant.PlantBlock;
import net.dries007.tfc.common.blocks.plant.fruit.Lifecycle;
import net.dries007.tfc.common.blocks.soil.FarmlandBlock;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.Month;
import net.dries007.tfc.util.climate.Climate;
import net.dries007.tfc.util.climate.ClimateRange;
import net.dries007.tfc.util.tracker.WorldTracker;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public abstract class SeasonalPlantBlock
extends BushBlock
implements IForgeBlockExtension,
EntityBlockExtension,
ISlowEntities {
    public static final VoxelShape PLANT_SHAPE = SeasonalPlantBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    public static final IntegerProperty STAGE = TFCBlockStateProperties.STAGE_2;
    public static final EnumProperty<Lifecycle> LIFECYCLE = TFCBlockStateProperties.LIFECYCLE;
    protected final Supplier<? extends Item> productItem;
    protected final Supplier<ClimateRange> climateRange;
    private final Lifecycle[] lifecycle;
    private final ExtendedProperties properties;

    public void randomTick(SeasonalPlantBlock plant, BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        plant.onUpdate((Level)level, pos, state);
    }

    public void onUpdate(Level level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BerryBushBlockEntity) {
            BlockPos stemPos;
            int hydration;
            ClimateRange range;
            BlockState newState;
            Lifecycle expectedLifecycle;
            BerryBushBlockEntity plant = (BerryBushBlockEntity)blockEntity;
            Lifecycle currentLifecycle = (Lifecycle)((Object)state.getValue(LIFECYCLE));
            if (!(SeasonalPlantBlock.checkAndSetDormant(level, pos, state, currentLifecycle, expectedLifecycle = this.getLifecycleForCurrentMonth(level, pos)) || state == (newState = (BlockState)state.setValue(LIFECYCLE, (Comparable)((Object)(currentLifecycle = (range = this.climateRange.get()).checkBoth(hydration = SeasonalPlantBlock.getFruitBushHydrationFromRootPos(level, (stemPos = plant.getStemPos()).below()), Climate.getAverageTemperature(level, stemPos), false) ? currentLifecycle.advanceTowards(expectedLifecycle) : Lifecycle.DORMANT)))) || currentLifecycle == Lifecycle.FLOWERING && Calendars.SERVER.getTicks() - plant.getLastPickedTick() <= (long)TFCConfig.SERVER.fruitPickBloomDelayTicks.get().intValue())) {
                level.setBlock(pos, newState, 3);
            }
        }
    }

    public static int distanceToGround(Level level, BlockPos pos, int distance) {
        BlockPos.MutableBlockPos mutablePos = pos.mutable();
        for (int i = 1; i <= distance; ++i) {
            mutablePos.move(Direction.DOWN);
            if (Helpers.isBlock(level.getBlockState((BlockPos)mutablePos), TFCTags.Blocks.SPREADING_BUSHES)) continue;
            return i;
        }
        return distance;
    }

    public static boolean checkAndSetDormant(Level level, BlockPos pos, BlockState state, Lifecycle current, Lifecycle expected) {
        if (expected == Lifecycle.DORMANT) {
            if (expected != current) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue(LIFECYCLE, (Comparable)((Object)Lifecycle.DORMANT)));
            }
            return true;
        }
        return false;
    }

    public static void randomDestroyTick(ServerLevel level, BlockPos pos, int days) {
        TickCounterBlockEntity counter;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TickCounterBlockEntity && (counter = (TickCounterBlockEntity)blockEntity).getTicksSinceUpdate() > 24000L * (long)days) {
            counter.setRemoved();
            level.destroyBlock(pos, true);
        }
    }

    public SeasonalPlantBlock(ExtendedProperties properties, Supplier<ClimateRange> climateRange, Supplier<? extends Item> productItem, Lifecycle[] lifecycle) {
        super(properties.properties());
        Preconditions.checkArgument((lifecycle.length == 12 ? 1 : 0) != 0, (Object)"Lifecycle length must be 12");
        this.properties = properties;
        this.climateRange = climateRange;
        this.lifecycle = lifecycle;
        this.productItem = productItem;
    }

    @Override
    public ExtendedProperties getExtendedProperties() {
        return this.properties;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (state.getValue(LIFECYCLE) == Lifecycle.FRUITING) {
            level.playSound(player, pos, SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.PLAYERS, 1.0f, level.getRandom().nextFloat() + 0.7f + 0.3f);
            if (!level.isClientSide()) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)this.getProductItem(level.random));
            }
            BerryBushBlockEntity.resetPickedTick(level, pos);
            level.setBlockAndUpdate(pos, this.stateAfterPicking(state));
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public BlockState stateAfterPicking(BlockState state) {
        return (BlockState)state.setValue(LIFECYCLE, (Comparable)((Object)Lifecycle.HEALTHY));
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Integer)state.getValue((Property)STAGE) == 2 ? Shapes.block() : PLANT_SHAPE;
    }

    protected VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity.getType() != EntityType.ITEM && Helpers.isBlock((Block)this, TFCTags.Blocks.THORNY_BUSHES)) {
            entity.hurt(entity.damageSources().sweetBerryBush(), 0.5f);
        }
    }

    @Override
    @Nullable
    public PathType getBlockPathType(BlockState state, BlockGetter level, BlockPos pos, @Nullable Mob entity) {
        return Helpers.isBlock((Block)this, TFCTags.Blocks.THORNY_BUSHES) ? PathType.DAMAGE_OTHER : PathType.OPEN;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LIFECYCLE, STAGE});
    }

    @Override
    public float slowEntityFactor(BlockState state) {
        float modifier = TFCConfig.SERVER.leavesMovementModifier.get().floatValue();
        if (state.hasProperty((Property)PlantBlock.AGE)) {
            modifier = Mth.lerp((float)((1.0f + (float)((Integer)state.getValue((Property)PlantBlock.AGE)).intValue()) / 4.0f), (float)1.0f, (float)modifier);
        }
        if (state.hasProperty((Property)STAGE)) {
            modifier = Mth.lerp((float)((float)(1 + (Integer)state.getValue((Property)STAGE)) / 3.0f), (float)1.0f, (float)modifier);
        }
        return modifier;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BerryBushBlockEntity.reset(level, pos);
        super.setPlacedBy(level, pos, state, placer, stack);
    }

    public ItemStack getProductItem(RandomSource random) {
        return new ItemStack((ItemLike)this.productItem.get());
    }

    protected static int getFruitBushHydration(Level level, BlockPos leafPos) {
        BlockPos sourcePos;
        BlockEntity blockEntity = level.getBlockEntity(leafPos);
        if (blockEntity instanceof BerryBushBlockEntity) {
            BerryBushBlockEntity bush = (BerryBushBlockEntity)blockEntity;
            sourcePos = bush.getStemPos().below();
        } else {
            TerraFirmaCraft.LOGGER.error("Fruit tree leaf block entity not present at {}", (Object)leafPos);
            sourcePos = leafPos;
        }
        return SeasonalPlantBlock.getFruitBushHydrationFromRootPos(level, sourcePos);
    }

    protected static int getFruitBushHydrationFromRootPos(Level level, BlockPos rootPos) {
        float averageRainfall = WorldTracker.get(level).getClimateModel().getAverageRainfall((LevelReader)level, rootPos);
        return FarmlandBlock.getHydrationFromRainHydration(level, rootPos, FarmlandBlock.getRainHydration(averageRainfall));
    }

    protected Lifecycle getLifecycleForCurrentMonth(Level level, BlockPos pos) {
        return this.getLifecycleForMonth(Calendars.SERVER.getHemispheralCalendarMonthOfYear(SolarCalculator.getInNorthernHemisphere(pos, level)));
    }

    protected Lifecycle getLifecycleForMonth(Month month) {
        return this.lifecycle[month.ordinal()];
    }

    protected boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
        return Helpers.isBlock(level.getBlockState(pos), TFCTags.Blocks.BUSH_PLANTABLE_ON);
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos belowPos = pos.below();
        return this.mayPlaceOn(level.getBlockState(belowPos), (BlockGetter)level, belowPos);
    }

    protected MapCodec<? extends BushBlock> codec() {
        return this.fakeBlockCodec();
    }
}

