/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.rock;

import net.dries007.tfc.util.Metal;
import net.dries007.tfc.util.registry.RegistryRock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;

public enum Ore {
    NATIVE_COPPER(Type.GRADED),
    NATIVE_GOLD(Type.GRADED),
    HEMATITE(Type.GRADED),
    NATIVE_SILVER(Type.GRADED),
    CASSITERITE(Type.GRADED),
    BISMUTHINITE(Type.GRADED),
    GARNIERITE(Type.GRADED),
    MALACHITE(Type.GRADED),
    MAGNETITE(Type.GRADED),
    LIMONITE(Type.GRADED),
    SPHALERITE(Type.GRADED),
    TETRAHEDRITE(Type.GRADED),
    GYPSUM(Type.NORMAL),
    CINNABAR(Type.NORMAL),
    CRYOLITE(Type.NORMAL),
    BORAX(Type.NORMAL),
    GRAPHITE(Type.NORMAL_WITH_POWDER),
    SALTPETER(Type.NORMAL_WITH_POWDER),
    SULFUR(Type.NORMAL_WITH_POWDER),
    SYLVITE(Type.NORMAL_WITH_POWDER),
    AMETHYST(Type.GEM),
    DIAMOND(Type.GEM),
    EMERALD(Type.GEM),
    LAPIS_LAZULI(Type.GEM),
    OPAL(Type.GEM),
    PYRITE(Type.GEM),
    RUBY(Type.GEM),
    SAPPHIRE(Type.GEM),
    TOPAZ(Type.GEM),
    BITUMINOUS_COAL(Type.ITEM_ONLY),
    LIGNITE(Type.ITEM_ONLY),
    HALITE(Type.ITEM_ONLY);

    private final Type type;

    private Ore(Type type) {
        this.type = type;
    }

    public boolean isGraded() {
        return this.type == Type.GRADED;
    }

    public boolean isGem() {
        return this.type == Type.GEM;
    }

    public boolean hasPowder() {
        return this.type != Type.NORMAL && this.type != Type.ITEM_ONLY;
    }

    public boolean hasBlock() {
        return this.type != Type.ITEM_ONLY;
    }

    public Metal metal() {
        return switch (this.ordinal()) {
            case 0, 7, 11 -> Metal.COPPER;
            case 1 -> Metal.GOLD;
            case 2, 8, 9 -> Metal.CAST_IRON;
            case 3 -> Metal.SILVER;
            case 4 -> Metal.TIN;
            case 5 -> Metal.BISMUTH;
            case 6 -> Metal.NICKEL;
            case 10 -> Metal.ZINC;
            default -> throw new IllegalStateException("No metal for ore " + String.valueOf((Object)this));
        };
    }

    public Block create(RegistryRock rock) {
        BlockBehaviour.Properties properties = BlockBehaviour.Properties.of().mapColor(MapColor.STONE).sound(SoundType.STONE).strength(rock.category().hardness(6.5f), 10.0f).requiresCorrectToolForDrops();
        return new Block(properties);
    }

    static enum Type {
        GRADED,
        NORMAL,
        NORMAL_WITH_POWDER,
        GEM,
        ITEM_ONLY;

    }

    public static enum Grade {
        POOR,
        NORMAL,
        RICH;

    }
}

