/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.rock;

import java.util.Locale;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.rock.IFallableBlock;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.fluids.FluidProperty;
import net.dries007.tfc.common.fluids.IFluidLoggable;
import net.dries007.tfc.common.recipes.CollapseRecipe;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class RockSpikeBlock
extends Block
implements IFluidLoggable,
IFallableBlock {
    public static final EnumProperty<Part> PART = TFCBlockStateProperties.ROCK_SPIKE_PART;
    public static final FluidProperty FLUID = TFCBlockStateProperties.WATER_AND_LAVA;
    public static final VoxelShape BASE_SHAPE = RockSpikeBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    public static final VoxelShape MIDDLE_SHAPE = RockSpikeBlock.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    public static final VoxelShape TIP_SHAPE = RockSpikeBlock.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);

    public RockSpikeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(PART, (Comparable)((Object)Part.BASE))).setValue((Property)this.getFluidProperty(), (Comparable)this.getFluidProperty().keyFor(Fluids.EMPTY)));
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        level.scheduleTick(pos, (Block)this, 1);
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        FluidHelpers.tickFluid(level, currentPos, state);
        return state;
    }

    @Override
    public FluidState getFluidState(BlockState state) {
        return IFluidLoggable.super.getFluidState(state);
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return switch (((Part)((Object)state.getValue(PART))).ordinal()) {
            case 0 -> BASE_SHAPE;
            case 1 -> MIDDLE_SHAPE;
            default -> TIP_SHAPE;
        };
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        this.checkForPossibleCollapse(state, level, pos, true);
    }

    protected boolean isRandomlyTicking(BlockState state) {
        return state.getFluidState().isRandomlyTicking();
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        state.getFluidState().randomTick((Level)level, pos, random);
    }

    @Override
    public void onceFinishedFalling(Level level, BlockPos pos, FallingBlockEntity fallingBlock) {
        level.setBlock(pos, level.getBlockState(pos).getFluidState().createLegacyBlock(), 3);
        Helpers.playSound(level, pos, (SoundEvent)TFCSounds.ROCK_SMASH.get());
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        FluidState fluidState = context.getLevel().getFluidState(context.getClickedPos());
        if (state != null && !fluidState.isEmpty()) {
            return (BlockState)state.setValue((Property)this.getFluidProperty(), (Comparable)this.getFluidProperty().keyForOrEmpty(fluidState.getType()));
        }
        return state;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    public PathType getBlockPathType(BlockState state, BlockGetter level, BlockPos pos, @Nullable Mob mob) {
        return PathType.BLOCKED;
    }

    @Override
    public FluidProperty getFluidProperty() {
        return FLUID;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{PART, this.getFluidProperty()});
    }

    private void checkForPossibleCollapse(BlockState state, ServerLevel level, BlockPos pos, boolean checkAbove) {
        BlockPos belowPos = pos.below();
        BlockState belowState = level.getBlockState(belowPos);
        if (belowState.getBlock() instanceof RockSpikeBlock && ((Part)((Object)belowState.getValue(PART))).isLargerThan((Part)((Object)state.getValue(PART)))) {
            level.scheduleTick(belowPos, (Block)this, 1);
            return;
        }
        if (belowState.isFaceSturdy((BlockGetter)level, belowPos, Direction.UP)) {
            return;
        }
        if (checkAbove) {
            BlockPos abovePos = pos.above();
            BlockState aboveState = level.getBlockState(abovePos);
            if (aboveState.getBlock() instanceof RockSpikeBlock && ((Part)((Object)aboveState.getValue(PART))).isLargerThan((Part)((Object)state.getValue(PART)))) {
                level.scheduleTick(abovePos, (Block)this, 1);
                return;
            }
            if (aboveState.isFaceSturdy((BlockGetter)level, abovePos, Direction.DOWN)) {
                return;
            }
        }
        if (CollapseRecipe.collapseBlock((Level)level, pos, state)) {
            if (belowState.getBlock() instanceof RockSpikeBlock) {
                this.checkForPossibleCollapse(belowState, level, belowPos, false);
            }
        } else {
            level.destroyBlock(pos, true);
        }
    }

    public static enum Part implements StringRepresentable
    {
        BASE,
        MIDDLE,
        TIP;

        private final String serializedName = this.name().toLowerCase(Locale.ROOT);

        public String getSerializedName() {
            return this.serializedName;
        }

        public boolean isLargerThan(Part other) {
            return this.ordinal() <= other.ordinal();
        }
    }
}

