/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.rotation;

import net.dries007.tfc.common.blocks.DirectionPropertyBlock;
import net.dries007.tfc.common.blocks.ExtendedBlock;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.fluids.FluidProperty;
import net.dries007.tfc.common.fluids.IFluidLoggable;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class FluidPipeBlock
extends ExtendedBlock
implements DirectionPropertyBlock,
IFluidLoggable {
    public static final FluidProperty FLUID = TFCBlockStateProperties.ALL_WATER;
    private static final VoxelShape[] SHAPES = new VoxelShape[64];

    public FluidPipeBlock(ExtendedProperties properties) {
        super(properties);
        this.registerDefaultState(DirectionPropertyBlock.setAllDirections((BlockState)this.getStateDefinition().any(), false));
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        FluidHelpers.tickFluid(level, currentPos, state);
        return this.updateConnectedSides(level, currentPos, state, null);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidState = context.getLevel().getFluidState(context.getClickedPos());
        BlockState state = this.updateConnectedSides((LevelAccessor)context.getLevel(), context.getClickedPos(), this.defaultBlockState(), context.getNearestLookingDirection());
        if (this.getFluidProperty().canContain(fluidState.getType())) {
            return (BlockState)state.setValue((Property)this.getFluidProperty(), (Comparable)this.getFluidProperty().keyFor(fluidState.getType()));
        }
        return state;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        int index = 0;
        for (Direction side : Helpers.DIRECTIONS) {
            if (!((Boolean)state.getValue((Property)DirectionPropertyBlock.getProperty(side))).booleanValue()) continue;
            index |= 1 << side.ordinal();
        }
        return SHAPES[index];
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add((Property[])PROPERTIES).add(new Property[]{this.getFluidProperty()});
    }

    @Override
    public FluidState getFluidState(BlockState state) {
        return IFluidLoggable.super.getFluidState(state);
    }

    @Override
    public FluidProperty getFluidProperty() {
        return FLUID;
    }

    @Override
    public BlockState rotate(BlockState state, Rotation rotation) {
        return DirectionPropertyBlock.rotate(state, rotation);
    }

    @Override
    public BlockState mirror(BlockState state, Mirror mirror) {
        return DirectionPropertyBlock.mirror(state, mirror);
    }

    private BlockState updateConnectedSides(LevelAccessor level, BlockPos pos, BlockState state, @Nullable Direction defaultDirection) {
        int openSides = 0;
        Direction openDirection = null;
        for (Direction direction : Helpers.DIRECTIONS) {
            BlockPos adjacentPos;
            BlockState adjacentState;
            boolean adjacentConnection;
            BooleanProperty property = DirectionPropertyBlock.getProperty(direction);
            if (defaultDirection == null && ((Boolean)state.getValue((Property)property)).booleanValue()) {
                defaultDirection = direction;
            }
            if (adjacentConnection = this.connectsToPipeInDirection(adjacentState = level.getBlockState(adjacentPos = pos.relative(direction)), direction)) {
                ++openSides;
                openDirection = direction;
            }
            state = (BlockState)state.setValue((Property)property, (Comparable)Boolean.valueOf(adjacentConnection));
        }
        if (openSides == 0) {
            assert (defaultDirection != null);
            return (BlockState)((BlockState)state.setValue((Property)DirectionPropertyBlock.getProperty(defaultDirection), (Comparable)Boolean.valueOf(true))).setValue((Property)DirectionPropertyBlock.getProperty(defaultDirection.getOpposite()), (Comparable)Boolean.valueOf(true));
        }
        if (openSides == 1) {
            return (BlockState)state.setValue((Property)DirectionPropertyBlock.getProperty(openDirection.getOpposite()), (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    private boolean connectsToPipeInDirection(BlockState state, Direction direction) {
        return state.getBlock() == this || state.getBlock() == TFCBlocks.STEEL_PUMP.get() && direction == Direction.UP;
    }

    static {
        VoxelShape north = FluidPipeBlock.box((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)5.0);
        VoxelShape south = FluidPipeBlock.box((double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0, (double)16.0);
        VoxelShape west = FluidPipeBlock.box((double)11.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0);
        VoxelShape east = FluidPipeBlock.box((double)0.0, (double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0);
        VoxelShape up = FluidPipeBlock.box((double)5.0, (double)11.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
        VoxelShape down = FluidPipeBlock.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)5.0, (double)11.0);
        VoxelShape[] directions = new VoxelShape[]{down, up, north, south, east, west};
        VoxelShape center = FluidPipeBlock.box((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);
        for (int i = 0; i < SHAPES.length; ++i) {
            VoxelShape shape = center;
            for (Direction direction : Helpers.DIRECTIONS) {
                if ((i >> direction.ordinal() & 1) != 1) continue;
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)directions[direction.ordinal()]);
            }
            FluidPipeBlock.SHAPES[i] = shape;
        }
    }
}

