/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.soil;

import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.config.TFCConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public interface IMudBlock {
    public BlockState getMud();

    default public ItemInteractionResult transformToMud(BlockState mud, Level level, BlockPos pos, Player player, InteractionHand hand) {
        FluidStack simulatedDrained;
        if (!TFCConfig.SERVER.enableDirtToMudCreation.get().booleanValue()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        ItemStack held = player.getItemInHand(hand);
        int waterRequired = 100;
        FluidStack water = new FluidStack((Fluid)Fluids.WATER, 100);
        IFluidHandler fluidHandler = (IFluidHandler)held.getCapability(Capabilities.FluidHandler.ITEM);
        if (fluidHandler != null && ((simulatedDrained = fluidHandler.drain(100, IFluidHandler.FluidAction.SIMULATE)).is(TFCTags.Fluids.ANY_FRESH_WATER) || simulatedDrained.is(TFCTags.Fluids.SALT_WATER)) && simulatedDrained.getAmount() >= 100) {
            fluidHandler.drain(100, IFluidHandler.FluidAction.EXECUTE);
            level.setBlockAndUpdate(pos, mud);
            FluidHelpers.playTransferSound(level, pos, water, FluidHelpers.Transfer.DRAIN);
            if (!level.isClientSide) {
                for (int i = 0; i < 5; ++i) {
                    ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.SPLASH, (double)pos.getX() + level.random.nextDouble(), (double)pos.getY() + 1.0, (double)pos.getZ() + level.random.nextDouble(), 1, 0.0, 0.0, 0.0, 1.0);
                }
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }
}

