/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.wood;

import java.util.function.Supplier;
import net.dries007.tfc.common.blocks.CharcoalPileBlock;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.GroundcoverBlock;
import net.dries007.tfc.common.blocks.ISlowEntities;
import net.dries007.tfc.common.blocks.wood.TFCLeavesBlock;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.config.TFCConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FallenLeavesBlock
extends GroundcoverBlock
implements ISlowEntities {
    public static final int MAX_LAYERS = 8;
    public static final IntegerProperty LAYERS = BlockStateProperties.LAYERS;
    private final Supplier<? extends Block> leaves;

    public FallenLeavesBlock(ExtendedProperties properties, Supplier<? extends Block> leaves) {
        super(properties, Shapes.block());
        this.leaves = leaves;
    }

    @Override
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack item = player.getItemInHand(hand);
        int layers = (Integer)state.getValue((Property)LAYERS);
        if (item.getItem() == this.asItem() && layers < 8) {
            if (!player.isCreative()) {
                item.shrink(1);
            }
            BlockState toPlace = layers + 1 == 8 ? (BlockState)this.leaves.get().defaultBlockState().setValue((Property)TFCLeavesBlock.PERSISTENT, (Comparable)Boolean.valueOf(true)) : (BlockState)state.setValue((Property)LAYERS, (Comparable)Integer.valueOf(layers + 1));
            level.setBlockAndUpdate(pos, toPlace);
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (layers == 1 && item.getItem() != this.asItem()) {
            return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Override
    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if ((Integer)state.getValue((Property)LAYERS) == 8) {
            FluidState fluid = state.getFluidState();
            BlockState newState = (BlockState)this.leaves.get().defaultBlockState().setValue((Property)TFCLeavesBlock.PERSISTENT, (Comparable)Boolean.valueOf(true));
            if ((newState = FluidHelpers.fillWithFluid(newState, fluid.getType())) != null) {
                return newState;
            }
        }
        return super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    public boolean isRandomlyTicking(BlockState state) {
        return true;
    }

    @Override
    public float slowEntityFactor(BlockState state) {
        return (Integer)state.getValue((Property)LAYERS) == 1 || !state.getFluidState().isEmpty() ? 1.0f : (float)((double)((float)((Integer)state.getValue((Property)LAYERS)).intValue() / 8.0f) * TFCConfig.SERVER.leavesMovementModifier.get());
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)builder.add(new Property[]{LAYERS}));
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return CharcoalPileBlock.SHAPE_BY_LAYER[(Integer)state.getValue((Property)LAYERS)];
    }

    public Supplier<? extends Block> getLeaves() {
        return this.leaves;
    }
}

