/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.capabilities;

import java.util.function.Supplier;
import net.dries007.tfc.common.blockentities.BarrelBlockEntity;
import net.dries007.tfc.common.blockentities.BlastFurnaceBlockEntity;
import net.dries007.tfc.common.blockentities.CrucibleBlockEntity;
import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.common.blockentities.LampBlockEntity;
import net.dries007.tfc.common.blockentities.MoldTableBlockEntity;
import net.dries007.tfc.common.blockentities.PotBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TFCChestBlockEntity;
import net.dries007.tfc.common.component.heat.IHeatConsumer;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public final class BlockCapabilities {
    public static final BlockCapability<IItemHandler, @Nullable Direction> ITEM = Capabilities.ItemHandler.BLOCK;
    public static final BlockCapability<IFluidHandler, @Nullable Direction> FLUID = Capabilities.FluidHandler.BLOCK;
    public static final BlockCapability<IHeatConsumer, @Nullable Direction> HEAT = BlockCapability.create((ResourceLocation)Helpers.identifier("heat"), IHeatConsumer.class, Direction.class);

    public static void register(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(ITEM, (BlockEntityType)TFCBlockEntities.ANVIL.get(), (object, context) -> object.getInventory());
        BlockCapabilities.registerInventory(event, TFCBlockEntities.BARREL);
        event.registerBlockEntity(FLUID, (BlockEntityType)TFCBlockEntities.BARREL.get(), BarrelBlockEntity::getSidedFluidInventory);
        BlockCapabilities.registerInventory(event, TFCBlockEntities.BLAST_FURNACE);
        event.registerBlockEntity(FLUID, (BlockEntityType)TFCBlockEntities.BLAST_FURNACE.get(), BlastFurnaceBlockEntity::getSidedFluidInventory);
        BlockCapabilities.registerInventory(event, TFCBlockEntities.BOWL);
        BlockCapabilities.registerInventory(event, TFCBlockEntities.CHARCOAL_FORGE);
        BlockCapabilities.registerInventory(event, TFCBlockEntities.COMPOSTER);
        BlockCapabilities.registerInventory(event, TFCBlockEntities.CRUCIBLE);
        BlockCapabilities.registerInventory(event, TFCBlockEntities.FIREBOX);
        event.registerBlockEntity(FLUID, (BlockEntityType)TFCBlockEntities.CRUCIBLE.get(), CrucibleBlockEntity::getSidedFluidInventory);
        event.registerBlockEntity(HEAT, (BlockEntityType)TFCBlockEntities.CRUCIBLE.get(), (object, context) -> (IHeatConsumer)object.getInventory());
        BlockCapabilities.registerInventory(event, TFCBlockEntities.FIREPIT);
        BlockCapabilities.registerInventory(event, TFCBlockEntities.GRILL);
        event.registerBlockEntity(FLUID, (BlockEntityType)TFCBlockEntities.LAMP.get(), LampBlockEntity::getSidedFluidInventory);
        BlockCapabilities.registerInventory(event, TFCBlockEntities.LARGE_VESSEL);
        BlockCapabilities.registerInventory(event, TFCBlockEntities.LOOM);
        BlockCapabilities.registerInventory(event, TFCBlockEntities.NEST_BOX);
        BlockCapabilities.registerInventory(event, TFCBlockEntities.POT);
        event.registerBlockEntity(FLUID, (BlockEntityType)TFCBlockEntities.POT.get(), PotBlockEntity::getSidedFluidInventory);
        BlockCapabilities.registerInventory(event, TFCBlockEntities.POWDERKEG);
        BlockCapabilities.registerInventory(event, TFCBlockEntities.QUERN);
        event.registerBlockEntity(ITEM, (BlockEntityType)TFCBlockEntities.CHEST.get(), TFCChestBlockEntity::getInventoryHandler);
        event.registerBlockEntity(ITEM, (BlockEntityType)TFCBlockEntities.TRAPPED_CHEST.get(), TFCChestBlockEntity::getInventoryHandler);
        BlockCapabilities.registerInventory(event, TFCBlockEntities.MOLD_TABLE);
        event.registerBlockEntity(FLUID, (BlockEntityType)TFCBlockEntities.MOLD_TABLE.get(), MoldTableBlockEntity::getSidedFluidInventory);
    }

    private static void registerInventory(RegisterCapabilitiesEvent event, Supplier<? extends BlockEntityType<? extends InventoryBlockEntity<?>>> type) {
        event.registerBlockEntity(ITEM, type.get(), InventoryBlockEntity::getSidedInventory);
    }
}

