/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.capabilities;

import java.util.Arrays;
import java.util.function.Function;
import net.dries007.tfc.common.capabilities.DelegateItemHandler;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class PartialItemHandler
implements DelegateItemHandler {
    private final IItemHandlerModifiable internal;
    private final boolean[] insertSlots;
    private final boolean[] extractSlots;

    public static Function<IItemHandlerModifiable, PartialItemHandler> only(int ... slots) {
        return handler -> new PartialItemHandler((IItemHandlerModifiable)handler).insert(slots).extract(slots);
    }

    public static Function<IItemHandlerModifiable, PartialItemHandler> extractOnly(int ... slots) {
        return handler -> new PartialItemHandler((IItemHandlerModifiable)handler).extract(slots);
    }

    public static Function<IItemHandlerModifiable, PartialItemHandler> insertOnly(int ... slots) {
        return handler -> new PartialItemHandler((IItemHandlerModifiable)handler).insert(slots);
    }

    public PartialItemHandler(IItemHandlerModifiable internal) {
        this.internal = internal;
        this.insertSlots = new boolean[internal.getSlots()];
        this.extractSlots = new boolean[internal.getSlots()];
    }

    public PartialItemHandler insertAll() {
        Arrays.fill(this.insertSlots, true);
        return this;
    }

    public PartialItemHandler insert(int ... slots) {
        for (int slot : slots) {
            this.insertSlots[slot] = true;
        }
        return this;
    }

    public PartialItemHandler extractAll() {
        Arrays.fill(this.extractSlots, true);
        return this;
    }

    public PartialItemHandler extract(int ... slots) {
        for (int slot : slots) {
            this.extractSlots[slot] = true;
        }
        return this;
    }

    @Override
    public IItemHandlerModifiable getItemHandler() {
        return this.internal;
    }

    @Override
    @NotNull
    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        return this.insertSlots[slot] ? this.internal.insertItem(slot, stack, simulate) : stack;
    }

    @Override
    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.extractSlots[slot] ? this.internal.extractItem(slot, amount, simulate) : ItemStack.EMPTY;
    }
}

