/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.util.Metal;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.minecraft.world.item.armortrim.TrimPatterns;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.server.command.EnumArgument;

public class AddTrimCommand {
    private static final String FAIL_NOT_ARMOR = "tfc.commands.trim.not_armor";
    private static final String FAIL_BAD_MATERIAL = "tfc.commands.trim.bad_material";
    private static final String FAIL_BAD_TEMPLATE = "tfc.commands.trim.bad_template";

    public static LiteralArgumentBuilder<CommandSourceStack> create(CommandBuildContext buildContext) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"trim").requires(source -> source.hasPermission(2))).then(Commands.argument((String)"material", (ArgumentType)ItemArgument.item((CommandBuildContext)buildContext)).then(((RequiredArgumentBuilder)Commands.argument((String)"pattern", (ArgumentType)ItemArgument.item((CommandBuildContext)buildContext)).executes(context -> AddTrimCommand.addTrim((CommandSourceStack)context.getSource(), ((ItemInput)context.getArgument("material", ItemInput.class)).getItem(), ((ItemInput)context.getArgument("pattern", ItemInput.class)).getItem(), ((CommandSourceStack)context.getSource()).getPlayerOrException().getMainHandItem()))).then(Commands.argument((String)"metal", (ArgumentType)EnumArgument.enumArgument(Metal.class)).executes(context -> AddTrimCommand.spawnSet((CommandSourceStack)context.getSource(), ((ItemInput)context.getArgument("material", ItemInput.class)).getItem(), ((ItemInput)context.getArgument("pattern", ItemInput.class)).getItem(), (Metal)context.getArgument("metal", Metal.class))))));
    }

    public static int spawnSet(CommandSourceStack source, Item materialItem, Item patternItem, Metal metal) throws CommandSyntaxException {
        if (!metal.allParts()) {
            source.sendFailure((Component)Component.translatable((String)FAIL_NOT_ARMOR));
            return 0;
        }
        Map<Metal.ItemType, TFCItems.ItemId> map = TFCItems.METAL_ITEMS.get(metal);
        ServerPlayer player = source.getPlayerOrException();
        for (Metal.ItemType type : new Metal.ItemType[]{Metal.ItemType.HELMET, Metal.ItemType.CHESTPLATE, Metal.ItemType.GREAVES, Metal.ItemType.BOOTS}) {
            ItemStack stack = ((Item)((Supplier)map.get((Object)type)).get()).getDefaultInstance();
            AddTrimCommand.addTrim(source, materialItem, patternItem, stack);
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack);
        }
        return 1;
    }

    public static int addTrim(CommandSourceStack source, Item materialItem, Item patternItem, ItemStack item) {
        Optional material = TrimMaterials.getFromIngredient((HolderLookup.Provider)source.registryAccess(), (ItemStack)materialItem.getDefaultInstance());
        Optional pattern = TrimPatterns.getFromTemplate((HolderLookup.Provider)source.registryAccess(), (ItemStack)patternItem.getDefaultInstance());
        if (material.isEmpty()) {
            source.sendFailure((Component)Component.translatable((String)FAIL_BAD_MATERIAL));
            return 0;
        }
        if (pattern.isEmpty()) {
            source.sendFailure((Component)Component.translatable((String)FAIL_BAD_TEMPLATE));
            return 0;
        }
        item.set(DataComponents.TRIM, (Object)new ArmorTrim((Holder)material.get(), (Holder)pattern.get()));
        return 1;
    }
}

