/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.function.Predicate;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.blocks.BlockPredicateArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;

public final class CountBlockCommand {
    private static final String DONE = "tfc.commands.count_block.done";

    public static LiteralArgumentBuilder<CommandSourceStack> create(CommandBuildContext cmdContext) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"count").requires(source -> source.hasPermission(2))).then(Commands.argument((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1, (int)250)).then(Commands.argument((String)"block", (ArgumentType)BlockPredicateArgument.blockPredicate((CommandBuildContext)cmdContext)).executes(context -> CountBlockCommand.countBlock((CommandSourceStack)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"radius"), BlockPredicateArgument.getBlockPredicate((CommandContext)context, (String)"block")))));
    }

    private static int countBlock(CommandSourceStack source, int radius, Predicate<BlockInWorld> block) {
        ServerLevel level = source.getLevel();
        BlockPos center = BlockPos.containing((Position)source.getPosition());
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        int found = 0;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                for (int y = level.getMinBuildHeight(); y < level.getMaxBuildHeight(); ++y) {
                    cursor.set((Vec3i)center).move(x, 0, z).setY(y);
                    if (!block.test(new BlockInWorld((LevelReader)level, (BlockPos)cursor, true))) continue;
                    ++found;
                }
            }
        }
        int finalFound = found;
        source.sendSuccess(() -> Component.translatable((String)DONE, (Object[])new Object[]{finalFound}), true);
        return 1;
    }
}

